/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Qt Software Information (qt-info@nokia.com)
**
** This file is part of the QtXMLPatterns module of the Qt Toolkit.
**
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License versions 2.0 or 3.0 as published by the Free
** Software Foundation and appearing in the file LICENSE.GPL included in
** the packaging of this file.  Please review the following information
** to ensure GNU General Public Licensing requirements will be met:
** http://www.fsf.org/licensing/licenses/info/GPLv2.html and
** http://www.gnu.org/copyleft/gpl.html.  In addition, as a special
** exception, Nokia gives you certain additional rights. These rights
** are described in the Nokia Qt GPL Exception version 1.3, included in
** the file GPL_EXCEPTION.txt in this package.
**
** Qt for Windows(R) Licensees
** As a special exception, Nokia, as the sole copyright holder for Qt
** Designer, grants users of the Qt/Eclipse Integration plug-in the
** right for the Qt/Eclipse Integration to link to functionality
** provided by Qt Designer and its related libraries.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
**
****************************************************************************/

#include "qcommonsequencetypes_p.h"

#include "qcalltemplate_p.h"

QT_BEGIN_NAMESPACE

using namespace QPatternist;

CallTemplate::CallTemplate(const QXmlName &name,
                           const WithParam::Hash &withParams) : TemplateInvoker(withParams, name)
{
}

Item::Iterator::Ptr CallTemplate::evaluateSequence(const DynamicContext::Ptr &context) const
{
    Q_ASSERT(m_template);
    return m_template->body->evaluateSequence(m_template->createContext(this, context, true));
}

bool CallTemplate::evaluateEBV(const DynamicContext::Ptr &context) const
{
    Q_ASSERT(m_template);
    return m_template->body->evaluateEBV(m_template->createContext(this, context, true));
}

void CallTemplate::evaluateToSequenceReceiver(const DynamicContext::Ptr &context) const
{
    Q_ASSERT(m_template);
    m_template->body->evaluateToSequenceReceiver(m_template->createContext(this, context, true));
}

Expression::Ptr CallTemplate::typeCheck(const StaticContext::Ptr &context,
                                        const SequenceType::Ptr &reqType)
{
    /* Check XTSE0680, that every @c xsl:with-param has a corresponding @c
     * xsl:param declaration. */
    {
        const WithParam::Hash::const_iterator end(m_withParams.constEnd());

        for(WithParam::Hash::const_iterator it(m_withParams.constBegin());
            it != end;
            ++it)
        {
            if(!VariableDeclaration::contains(m_template->templateParameters, it.value()->name()))
                Template::raiseXTSE0680(context, it.value()->name(), this);
        }
    }

    const Expression::Ptr me(TemplateInvoker::typeCheck(context, reqType));

    const VariableDeclaration::List args(m_template->templateParameters);
    const VariableDeclaration::List::const_iterator end(args.constEnd());
    VariableDeclaration::List::const_iterator it(args.constBegin());

    for(; it != end; ++it)
    {
        // TODO
        Q_ASSERT((*it)->sequenceType);
    }

    return me;
}

Expression::Properties CallTemplate::properties() const
{
    Q_ASSERT(!m_template || m_template->body);

    /* We may be called before our m_template is resolved, namely when we're
     * the body of a variable. In that case querytransformparser.ypp will
     * manually call TypeChecker::applyFunctionConversion(), which is before
     * ExpressionFactory::createExpression() has resolved us. */
    if(m_template && !isRecursive())
        return m_template->properties();
    else
        return Properties();
}

Expression::Properties CallTemplate::dependencies() const
{
    if(m_template && !isRecursive())
        return m_template->dependencies();
    else
        return Properties();
}

SequenceType::Ptr CallTemplate::staticType() const
{
    return CommonSequenceTypes::ZeroOrMoreItems;
}

ExpressionVisitorResult::Ptr CallTemplate::accept(const ExpressionVisitor::Ptr &visitor) const
{
    return visitor->visit(this);
}

bool CallTemplate::configureRecursion(const CallTargetDescription::Ptr &sign)
{
    Q_UNUSED(sign);
    return false;
}

Expression::Ptr CallTemplate::body() const
{
    return m_template->body;
}

CallTargetDescription::Ptr CallTemplate::callTargetDescription() const
{
    return CallTargetDescription::Ptr();
}

QT_END_NAMESPACE
