#ifdef Q_WS_HILDON

#include "qx11info_x11.h"
#include "private/qt_x11_p.h"

/******* these are copied from hildon-im-protocol **********/

#define HILDON_IM_CLIENT_MESSAGE_BUFFER_SIZE (20 - sizeof(int))

/* Commit modes
   Determines how text is inserted into the client widget

   Buffered mode:  Each new commit replaces any previous commit to the
   client widget until FLUSH_PREEDIT is called.

   Direct mode (default): Each commit is immediately appended to the
   client widget at the cursor position.

   Redirect mode: Proxies input and cursor movement from one text widget
   into another (potentially off-screen) widget. Used when implementing
   fullscreen IM plugins for widgets that contain text formatting.

   Surrounding mode: Each commit replaces the current text surrounding
   the cursor position (see gtk_im_context_get_surrounding).
*/
typedef enum
{
  HILDON_IM_COMMIT_DIRECT,
  HILDON_IM_COMMIT_REDIRECT,
  HILDON_IM_COMMIT_SURROUNDING,
  HILDON_IM_COMMIT_BUFFERED,
} HildonIMCommitMode;

/* Type markers for IM messages that span several ClientMessages */
enum
{
  HILDON_IM_MSG_START,
  HILDON_IM_MSG_CONTINUE,
  HILDON_IM_MSG_END
};

/* Message carrying surrounding interpretation info, sent by both IM and context */
typedef struct
{
  HildonIMCommitMode commit_mode;
  int offset_is_relative;
  int cursor_offset;
} HildonIMSurroundingMessage;

/* The surrounding text, sent by both IM and context */
typedef struct
{
  int msg_flag;
  char surrounding[HILDON_IM_CLIENT_MESSAGE_BUFFER_SIZE];
} HildonIMSurroundingContentMessage;

enum
{
    HILDON_IM_ACTIVATE_FORMAT = 8,
//  HILDON_IM_COM_FORMAT =8,
    HILDON_IM_INSERT_UTF8_FORMAT = 8,
    HILDON_IM_KEY_EVENT_FORMAT = 8,
    HILDON_IM_SURROUNDING_CONTENT_FORMAT = 8,
    HILDON_IM_SURROUNDING_FORMAT = 8,
    HILDON_IM_CLIPBOARD_SELECTION_REPLY_FORMAT = 32,
//  HILDON_IM_CLIPBOARD_FORMAT = 32
    HILDON_IM_WINDOW_ID_FORMAT = 32,
    HILDON_IM_DEFAULT_LAUNCH_DELAY = 70
}; /* IM ClientMessage formats */

/* IM commands, from context to IM process */
enum HildonIMCommand
{
    HILDON_IM_MODE,       // Update the hildon-input-mode property
    HILDON_IM_SHOW,       // Show the IM UI
    HILDON_IM_HIDE,       // Hide the IM UI
    HILDON_IM_UPP,        // Uppercase autocap state at cursor
    HILDON_IM_LOW,        // Lowercase autocap state at cursor
    HILDON_IM_DESTROY,    // DEPRECATED
    HILDON_IM_CLEAR,      // Clear the IM UI state
    HILDON_IM_SETCLIENT,  // Set the client window
    HILDON_IM_SETNSHOW,   // Set the client and show the IM window 
    HILDON_IM_SELECT_ALL, // Select the text in the plugin

    /* always last */
    HILDON_IM_NUM_COMMANDS
};

enum HildonIMTrigger
{
    HILDON_IM_TRIGGER_NONE = -1,
    HILDON_IM_TRIGGER_STYLUS,
    HILDON_IM_TRIGGER_FINGER,
    HILDON_IM_TRIGGER_KEYBOARD
};

struct HildonIMActivateMessage
{
    Window input_window;
    Window app_window;
    HildonIMCommand cmd;
    int input_mode;
    HildonIMTrigger trigger;
};

struct HildonIMInsertUtf8Message
{
    int msg_flag;
    char utf8_str[HILDON_IM_CLIENT_MESSAGE_BUFFER_SIZE];
};

/* IM communications, from IM process to context */
typedef enum
{
  HILDON_IM_CONTEXT_HANDLE_ENTER,           /* Virtual enter activated */
  HILDON_IM_CONTEXT_HANDLE_TAB,             /* Virtual tab activated */
  HILDON_IM_CONTEXT_HANDLE_BACKSPACE,       /* Virtual backspace activated */
  HILDON_IM_CONTEXT_HANDLE_SPACE,           /* Virtual space activated */
  HILDON_IM_CONTEXT_CONFIRM_SENTENCE_START, /* Query the autocap state at cursor */
  HILDON_IM_CONTEXT_FLUSH_PREEDIT,          /* Finalize the preedit to the client widget */

  /* See HildonIMCommitMode for a description of the commit modes */
  HILDON_IM_CONTEXT_BUFFERED_MODE,
  HILDON_IM_CONTEXT_DIRECT_MODE,
  HILDON_IM_CONTEXT_REDIRECT_MODE,
  HILDON_IM_CONTEXT_SURROUNDING_MODE,

  HILDON_IM_CONTEXT_CLIPBOARD_COPY,            /* Copy client selection to clipboard */
  HILDON_IM_CONTEXT_CLIPBOARD_CUT,             /* Cut client selection to clipboard */
  HILDON_IM_CONTEXT_CLIPBOARD_PASTE,           /* Paste clipboard selection to client */
  HILDON_IM_CONTEXT_CLIPBOARD_SELECTION_QUERY, /* Query if the client has an active selection */

  HILDON_IM_CONTEXT_REQUEST_SURROUNDING,       /* Request the content surrounding the cursor */
  HILDON_IM_CONTEXT_WIDGET_CHANGED,            /* IM detected that the client widget changed */
  HILDON_IM_CONTEXT_OPTION_CHANGED,            /* The OptionMask for the active context is updated */
  HILDON_IM_CONTEXT_CLEAR_STICKY,              /* Clear the sticky key state */
  HILDON_IM_CONTEXT_ENTER_ON_FOCUS,            /* Generate a virtual enter key event on focus in */

  /* always last */
  HILDON_IM_CONTEXT_NUM_COM
} HildonIMCommunication;

enum HildonIMOptionMask
{
  HILDON_IM_AUTOCASE          = 1 << 0,
  HILDON_IM_AUTOCORRECT       = 1 << 1,
  HILDON_IM_AUTOLEVEL_NUMERIC = 1 << 2,
  HILDON_IM_LOCK_LEVEL        = 1 << 3
};

struct HildonIMComMessage
{
    Window input_window;
    HildonIMCommunication type;
    HildonIMOptionMask options;
};

/* Key event message, from context to IM */
typedef struct
{
  Window input_window;
  int type;
  unsigned int state;
  unsigned int keyval;
  unsigned int hardware_keycode;
} HildonIMKeyEventMessage;


typedef enum {
  HILDON_IM_SHIFT_STICKY_MASK     = 1 << 0,
  HILDON_IM_SHIFT_LOCK_MASK       = 1 << 1,
  HILDON_IM_LEVEL_STICKY_MASK     = 1 << 2,
  HILDON_IM_LEVEL_LOCK_MASK       = 1 << 3,
  HILDON_IM_COMPOSE_MASK          = 1 << 4,
  HILDON_IM_DEAD_KEY_MASK         = 1 << 5,
} HildonIMInternalModifierMask;


#endif
