/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(VIDEO)

#include "JSMediaError.h"

#include <wtf/GetPtr.h>

#include "MediaError.h"

#include <runtime/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSMediaError)

/* Hash table */

static const HashTableValue JSMediaErrorTableValues[3] =
{
    { "code", DontDelete|ReadOnly, (intptr_t)jsMediaErrorCode, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsMediaErrorConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSMediaErrorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSMediaErrorTableValues, 0 };
#else
    { 5, 3, JSMediaErrorTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSMediaErrorConstructorTableValues[4] =
{
    { "MEDIA_ERR_ABORTED", DontDelete|ReadOnly, (intptr_t)jsMediaErrorMEDIA_ERR_ABORTED, (intptr_t)0 },
    { "MEDIA_ERR_NETWORK", DontDelete|ReadOnly, (intptr_t)jsMediaErrorMEDIA_ERR_NETWORK, (intptr_t)0 },
    { "MEDIA_ERR_DECODE", DontDelete|ReadOnly, (intptr_t)jsMediaErrorMEDIA_ERR_DECODE, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSMediaErrorConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 3, JSMediaErrorConstructorTableValues, 0 };
#else
    { 8, 7, JSMediaErrorConstructorTableValues, 0 };
#endif

class JSMediaErrorConstructor : public DOMObject {
public:
    JSMediaErrorConstructor(ExecState* exec)
        : DOMObject(JSMediaErrorConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSMediaErrorPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValuePtr proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSMediaErrorConstructor::s_info = { "MediaErrorConstructor", 0, &JSMediaErrorConstructorTable, 0 };

bool JSMediaErrorConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMediaErrorConstructor, DOMObject>(exec, &JSMediaErrorConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSMediaErrorPrototypeTableValues[4] =
{
    { "MEDIA_ERR_ABORTED", DontDelete|ReadOnly, (intptr_t)jsMediaErrorMEDIA_ERR_ABORTED, (intptr_t)0 },
    { "MEDIA_ERR_NETWORK", DontDelete|ReadOnly, (intptr_t)jsMediaErrorMEDIA_ERR_NETWORK, (intptr_t)0 },
    { "MEDIA_ERR_DECODE", DontDelete|ReadOnly, (intptr_t)jsMediaErrorMEDIA_ERR_DECODE, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSMediaErrorPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 3, JSMediaErrorPrototypeTableValues, 0 };
#else
    { 8, 7, JSMediaErrorPrototypeTableValues, 0 };
#endif

const ClassInfo JSMediaErrorPrototype::s_info = { "MediaErrorPrototype", 0, &JSMediaErrorPrototypeTable, 0 };

JSObject* JSMediaErrorPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSMediaError>(exec);
}

bool JSMediaErrorPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMediaErrorPrototype, JSObject>(exec, &JSMediaErrorPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSMediaError::s_info = { "MediaError", 0, &JSMediaErrorTable, 0 };

JSMediaError::JSMediaError(PassRefPtr<Structure> structure, PassRefPtr<MediaError> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSMediaError::~JSMediaError()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSMediaError::createPrototype(ExecState* exec)
{
    return new (exec) JSMediaErrorPrototype(JSMediaErrorPrototype::createStructure(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSMediaError::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMediaError, Base>(exec, &JSMediaErrorTable, this, propertyName, slot);
}

JSValuePtr jsMediaErrorCode(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    MediaError* imp = static_cast<MediaError*>(static_cast<JSMediaError*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->code());
}

JSValuePtr jsMediaErrorConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSMediaError*>(asObject(slot.slotBase()))->getConstructor(exec);
}
JSValuePtr JSMediaError::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSMediaErrorConstructor>(exec);
}

// Constant getters

JSValuePtr jsMediaErrorMEDIA_ERR_ABORTED(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValuePtr jsMediaErrorMEDIA_ERR_NETWORK(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(2));
}

JSValuePtr jsMediaErrorMEDIA_ERR_DECODE(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(3));
}

JSC::JSValuePtr toJS(JSC::ExecState* exec, MediaError* object)
{
    return getDOMObjectWrapper<JSMediaError>(exec, object);
}
MediaError* toMediaError(JSC::JSValuePtr value)
{
    return value->isObject(&JSMediaError::s_info) ? static_cast<JSMediaError*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(VIDEO)
