/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Qt Software Information (qt-info@nokia.com)
**
** This file is part of the QtXMLPatterns module of the Qt Toolkit.
**
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License versions 2.0 or 3.0 as published by the Free
** Software Foundation and appearing in the file LICENSE.GPL included in
** the packaging of this file.  Please review the following information
** to ensure GNU General Public Licensing requirements will be met:
** http://www.fsf.org/licensing/licenses/info/GPLv2.html and
** http://www.gnu.org/copyleft/gpl.html.  In addition, as a special
** exception, Nokia gives you certain additional rights. These rights
** are described in the Nokia Qt GPL Exception version 1.3, included in
** the file GPL_EXCEPTION.txt in this package.
**
** Qt for Windows(R) Licensees
** As a special exception, Nokia, as the sole copyright holder for Qt
** Designer, grants users of the Qt/Eclipse Integration plug-in the
** right for the Qt/Eclipse Integration to link to functionality
** provided by Qt Designer and its related libraries.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
**
****************************************************************************/

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists purely as an
// implementation detail.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.

#ifndef Patternist_Validate_H
#define Patternist_Validate_H

#include "qexpression_p.h"

QT_BEGIN_HEADER

QT_BEGIN_NAMESPACE

namespace QPatternist
{
    /**
     * @short Handles XQuery 1.0's <tt>validate</tt> expression.
     *
     * This class is currently not used. The Schema Validation Feature is not supported.
     *
     * @see <a href="http://www.w3.org/TR/xquery/#id-validate">XQuery 1.0: An XML
     * Query Language, 3.13 Validate Expressions</a>
     * @see <a href="http://www.w3.org/TR/xquery/#id-schema-validation-feature">XQuery 1.0: An
     * XML Query Language, 5.2.2 Schema Validation Feature</a>
     * @author Frans Englich <fenglich@trolltech.com>
     * @ingroup Patternist_expressions
     */
    class Validate
    {
    public:

        /**
         * Represents the validation mode.
         */
        enum Mode
        {
            Lax = 1,
            Strict
        };

        /**
         * Creates the necessary Expression instances
         * that validates the operand node @p operandNode in mode @p validationMode,
         * and returns it.
         */
        static Expression::Ptr create(const Expression::Ptr &operandNode,
                                      const Mode validationMode,
                                      const StaticContext::Ptr &context);
    private:
        Validate();
        Q_DISABLE_COPY(Validate)
    };
}

QT_END_NAMESPACE

QT_END_HEADER

#endif
