/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Qt Software Information (qt-info@nokia.com)
**
** This file is part of the QtXMLPatterns module of the Qt Toolkit.
**
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License versions 2.0 or 3.0 as published by the Free
** Software Foundation and appearing in the file LICENSE.GPL included in
** the packaging of this file.  Please review the following information
** to ensure GNU General Public Licensing requirements will be met:
** http://www.fsf.org/licensing/licenses/info/GPLv2.html and
** http://www.gnu.org/copyleft/gpl.html.  In addition, as a special
** exception, Nokia gives you certain additional rights. These rights
** are described in the Nokia Qt GPL Exception version 1.3, included in
** the file GPL_EXCEPTION.txt in this package.
**
** Qt for Windows(R) Licensees
** As a special exception, Nokia, as the sole copyright holder for Qt
** Designer, grants users of the Qt/Eclipse Integration plug-in the
** right for the Qt/Eclipse Integration to link to functionality
** provided by Qt Designer and its related libraries.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
**
****************************************************************************/

#include "qbuiltintypes_p.h"

#include "qgyearmonth_p.h"

QT_BEGIN_NAMESPACE

using namespace QPatternist;

GYearMonth::GYearMonth(const QDateTime &dateTime) : AbstractDateTime(dateTime)
{
}

GYearMonth::Ptr GYearMonth::fromLexical(const QString &lexical)
{
    static const CaptureTable captureTable( // STATIC DATA
        /* The extra paranthesis is a build fix for GCC 3.3. */
        (QRegExp(QLatin1String(
                "^\\s*"                             /* Any preceding whitespace. */
                "(-?)"                              /* Any preceding minus. */
                "(\\d{4,})"                         /* The year part. */
                "-"                                 /* Delimiter. */
                "(\\d{2})"                          /* The month part. */
                "(?:(\\+|-)(\\d{2}):(\\d{2})|(Z))?" /* The zone offset, "+08:24". */
                "\\s*$"                             /* Any terminating whitespace. */))),
        /*zoneOffsetSignP*/         4,
        /*zoneOffsetHourP*/         5,
        /*zoneOffsetMinuteP*/       6,
        /*zoneOffsetUTCSymbolP*/    7,
        /*yearP*/                   2,
        /*monthP*/                  3,
        /*dayP*/                    -1,
        /*hourP*/                   -1,
        /*minutesP*/                -1,
        /*secondsP*/                -1,
        /*msecondsP*/               -1,
        /*yearSign*/                1);

    AtomicValue::Ptr err;
    const QDateTime retval(create(err, lexical, captureTable));

    return err ? err : GYearMonth::Ptr(new GYearMonth(retval));
}

GYearMonth::Ptr GYearMonth::fromDateTime(const QDateTime &dt)
{
    QDateTime result(QDate(dt.date().year(), dt.date().month(), DefaultDay));
    copyTimeSpec(dt, result);

    return GYearMonth::Ptr(new GYearMonth(result));
}

QString GYearMonth::stringValue() const
{
    return m_dateTime.toString(QLatin1String("yyyy-MM")) + zoneOffsetToString();
}

ItemType::Ptr GYearMonth::type() const
{
    return BuiltinTypes::xsGYearMonth;
}

QT_END_NAMESPACE
