/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Qt Software Information (qt-info@nokia.com)
**
** This file is part of the QtXMLPatterns module of the Qt Toolkit.
**
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License versions 2.0 or 3.0 as published by the Free
** Software Foundation and appearing in the file LICENSE.GPL included in
** the packaging of this file.  Please review the following information
** to ensure GNU General Public Licensing requirements will be met:
** http://www.fsf.org/licensing/licenses/info/GPLv2.html and
** http://www.gnu.org/copyleft/gpl.html.  In addition, as a special
** exception, Nokia gives you certain additional rights. These rights
** are described in the Nokia Qt GPL Exception version 1.3, included in
** the file GPL_EXCEPTION.txt in this package.
**
** Qt for Windows(R) Licensees
** As a special exception, Nokia, as the sole copyright holder for Qt
** Designer, grants users of the Qt/Eclipse Integration plug-in the
** right for the Qt/Eclipse Integration to link to functionality
** provided by Qt Designer and its related libraries.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
**
****************************************************************************/

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists purely as an
// implementation detail.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.

#ifndef Patternist_CommonSequenceTypes_H
#define Patternist_CommonSequenceTypes_H

#include "qemptysequencetype_p.h"
#include "qnonetype_p.h"

QT_BEGIN_HEADER

QT_BEGIN_NAMESPACE

namespace QPatternist
{
    /**
     * @short Provides access to singleton instances of SequenceType sub-classes.
     *
     * @ingroup Patternist_types
     * @author Frans Englich <fenglich@trolltech.com>
     */
    class Q_AUTOTEST_EXPORT CommonSequenceTypes
    {
    public:
        /**
         * <tt>xs:anyAtomicType?</tt>
         */
        static const SequenceType::Ptr ZeroOrOneAtomicType;

        /**
         * <tt>xs:anyAtomicType</tt>
         */
        static const SequenceType::Ptr ExactlyOneAtomicType;

        /**
         * <tt>xs:anyAtomicType*</tt>
         */
        static const SequenceType::Ptr ZeroOrMoreAtomicTypes;

        /**
         * <tt>item()</tt>
         */
        static const SequenceType::Ptr ExactlyOneItem;

        /**
         * <tt>item()*</tt>
         */
        static const SequenceType::Ptr ZeroOrMoreItems;

        /**
         * <tt>item()?</tt>
         */
        static const SequenceType::Ptr ZeroOrOneItem;

        /**
         * <tt>item()+</tt>
         */
        static const SequenceType::Ptr OneOrMoreItems;

        /**
         * The empty sequence, <tt>empty-sequence()</tt>.
         */
        static const EmptySequenceType::Ptr Empty;

        /**
         * The special type @c none. Used for the function <tt>fn:error()</tt>, for example.
         */
        static const NoneType::Ptr None;

        /**
         * <tt>xs:anyURI</tt>
         */
        static const SequenceType::Ptr ExactlyOneAnyURI;

        /**
         * <tt>xs:boolean</tt>
         */
        static const SequenceType::Ptr ExactlyOneBoolean;

        /**
         * <tt>xs:boolean?</tt>
         */
        static const SequenceType::Ptr ZeroOrOneBoolean;

        /**
         * <tt>xs:untypedAtomic</tt>
         */
        static const SequenceType::Ptr ExactlyOneUntypedAtomic;

        /**
         * <tt>xs:integer</tt>
         */
        static const SequenceType::Ptr ExactlyOneInteger;

        /**
         * <tt>xs:integer?</tt>
         */
        static const SequenceType::Ptr ZeroOrOneInteger;

        /**
         * <tt>xs:decimal?</tt>
         */
        static const SequenceType::Ptr ZeroOrOneDecimal;

        /**
         * <tt>xs:integer*</tt>
         */
        static const SequenceType::Ptr ZeroOrMoreIntegers;

        /**
         * <tt>xs:double</tt>
         */
        static const SequenceType::Ptr ExactlyOneDouble;

        /**
         * <tt>xs:decimal</tt>
         */
        static const SequenceType::Ptr ExactlyOneDecimal;

        /**
         * <tt>xs:float</tt>
         */
        static const SequenceType::Ptr ExactlyOneFloat;

        /**
         * <tt>xs:QName</tt>
         */
        static const SequenceType::Ptr ExactlyOneQName;

        /**
         * <tt>xs:string</tt>
         */
        static const SequenceType::Ptr ExactlyOneString;

        /**
         * <tt>xs:string?</tt>
         */
        static const SequenceType::Ptr ZeroOrOneString;

        /**
         * <tt>xs:string*</tt>
         */
        static const SequenceType::Ptr ZeroOrMoreStrings;

        /**
         * <tt>xs:NCName?</tt>
         */
        static const SequenceType::Ptr ZeroOrOneNCName;

        /**
         * <tt>xs:NCName</tt>
         */
        static const SequenceType::Ptr ExactlyOneNCName;

        /**
         * <tt>xs:QName?</tt>
         */
        static const SequenceType::Ptr ZeroOrOneQName;

        /**
         * The artificial type in XPath 2.0 that covers @c xs:double, @c xs:float,
         * @c xs:decimal, with cardinality zero or one.
         *
         * @see <a href="http://www.w3.org/TR/xpath20/#dt-numeric">XML Path Language
         * (XPath) 2.0, definition for Numeric</a>
         * @see <a href="http://www.w3.org/TR/xpath-functions/#func-signatures">XQuery 1.0
         * and XPath 2.0 Functions and Operators, 1.3 Function Signatures and Descriptions</a>
         * @see BuiltinTypes::numeric
         */
        static const SequenceType::Ptr ZeroOrOneNumeric;

        /**
         * @c numeric
         */
        static const SequenceType::Ptr ExactlyOneNumeric;

        /**
         * <tt>node()?</tt>
         */
        static const SequenceType::Ptr ZeroOrOneNode;

        /**
         * <tt>node()</tt>
         */
        static const SequenceType::Ptr ExactlyOneNode;

        /**
         * <tt>node()*</tt>
         */
        static const SequenceType::Ptr ZeroOrMoreNodes;

        /**
         * <tt>element()</tt>
         */
        static const SequenceType::Ptr ExactlyOneElement;

        /**
         * <tt>processing-instruction()</tt>
         */
        static const SequenceType::Ptr ExactlyOneProcessingInstruction;

        /**
         * <tt>attribute()</tt>
         */
        static const SequenceType::Ptr ExactlyOneAttribute;

        /**
         * <tt>text()</tt>
         */
        static const SequenceType::Ptr ExactlyOneTextNode;

        /**
         * <tt>text()?</tt>
         */
        static const SequenceType::Ptr ZeroOrOneTextNode;

        /**
         * <tt>comment()</tt>
         */
        static const SequenceType::Ptr ExactlyOneComment;

        /**
         * <tt>element()*</tt>
         */
        static const SequenceType::Ptr ZeroOrMoreElements;

        /**
         * <tt>document-node()?</tt>
         */
        static const SequenceType::Ptr ZeroOrOneDocumentNode;

        /**
         * <tt>document-node()</tt>
         */
        static const SequenceType::Ptr ExactlyOneDocumentNode;

        /**
         * <tt>document-node()+</tt>
         */
        static const SequenceType::Ptr OneOrMoreDocumentNodes;

        /**
         * Identifiers all values which the Effective %Boolean Value
         * can be extracted from.
         */
        static const SequenceType::Ptr EBV;

        /**
         * <tt>xs:anyURI?</tt>
         */
        static const SequenceType::Ptr ZeroOrOneAnyURI;

        /**
         * <tt>xs:hexBinary</tt>
         */
        static const SequenceType::Ptr ExactlyOneHexBinary;

        /**
         * <tt>xs:base64Binary</tt>
         */
        static const SequenceType::Ptr ExactlyOneBase64Binary;

        /**
         * <tt>xs:date</tt>
         */
        static const SequenceType::Ptr ExactlyOneDate;

        /**
         * <tt>xs:dateTime</tt>
         */
        static const SequenceType::Ptr ExactlyOneDateTime;

        /**
         * <tt>xs:dayTimeDuration</tt>
         */
        static const SequenceType::Ptr ExactlyOneDayTimeDuration;

        /**
         * <tt>xs:duration</tt>
         */
        static const SequenceType::Ptr ExactlyOneDuration;

        /**
         * <tt>xs:gDay</tt>
         */
        static const SequenceType::Ptr ExactlyOneGDay;

        /**
         * <tt>xs:gMonth</tt>
         */
        static const SequenceType::Ptr ExactlyOneGMonth;

        /**
         * <tt>xs:gMonthDay</tt>
         */
        static const SequenceType::Ptr ExactlyOneGMonthDay;

        /**
         * <tt>xs:gYear</tt>
         */
        static const SequenceType::Ptr ExactlyOneGYear;

        /**
         * <tt>xs:gYearMonth</tt>
         */
        static const SequenceType::Ptr ExactlyOneGYearMonth;

        /**
         * <tt>xs:yearMonthDuration</tt>
         */
        static const SequenceType::Ptr ExactlyOneYearMonthDuration;

        /**
         * <tt>xs:time</tt>
         */
        static const SequenceType::Ptr ExactlyOneTime;

        /**
         * <tt>xs:time?</tt>
         */
        static const SequenceType::Ptr ZeroOrOneDate;

        /**
         * <tt>xs:dateTime?</tt>
         */
        static const SequenceType::Ptr ZeroOrOneDateTime;

        /**
         * <tt>xs:dayTimeDuration?</tt>
         */
        static const SequenceType::Ptr ZeroOrOneDayTimeDuration;

        /**
         * <tt>xs:duration?</tt>
         */
        static const SequenceType::Ptr ZeroOrOneDuration;

        /**
         * <tt>xs:time?</tt>
         */
        static const SequenceType::Ptr ZeroOrOneTime;

        /**
         * <tt>xs:yearMonthDuration?</tt>
         */
        static const SequenceType::Ptr ZeroOrOneYearMonthDuration;

    private:
        /**
         * The constructor is private and has no implementation,
         * because this class is not meant to be instantiated.
         *
         * It should only be used via its static members.
         */
        inline CommonSequenceTypes();

        Q_DISABLE_COPY(CommonSequenceTypes)
    };
}

QT_END_NAMESPACE

QT_END_HEADER

#endif

