/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Qt Software Information (qt-info@nokia.com)
**
** This file is part of the QtXMLPatterns module of the Qt Toolkit.
**
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License versions 2.0 or 3.0 as published by the Free
** Software Foundation and appearing in the file LICENSE.GPL included in
** the packaging of this file.  Please review the following information
** to ensure GNU General Public Licensing requirements will be met:
** http://www.fsf.org/licensing/licenses/info/GPLv2.html and
** http://www.gnu.org/copyleft/gpl.html.  In addition, as a special
** exception, Nokia gives you certain additional rights. These rights
** are described in the Nokia Qt GPL Exception version 1.3, included in
** the file GPL_EXCEPTION.txt in this package.
**
** Qt for Windows(R) Licensees
** As a special exception, Nokia, as the sole copyright holder for Qt
** Designer, grants users of the Qt/Eclipse Integration plug-in the
** right for the Qt/Eclipse Integration to link to functionality
** provided by Qt Designer and its related libraries.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
**
****************************************************************************/

#include "qqnameconstructor_p.h"

#include "qelementavailablefn_p.h"

QT_BEGIN_NAMESPACE

using namespace QPatternist;

ElementAvailableFN::ElementAvailableFN() : m_xsltInstructions(allXSLTInstructions())
{
}

QSet<QString> ElementAvailableFN::allXSLTInstructions()
{
    enum
    {
        StringSetSize = 27
    };

    QSet<QString> retval;
    retval.reserve(StringSetSize);

    /* Alphabetically. */
    retval.insert(QLatin1String("analyze-string"));
    retval.insert(QLatin1String("apply-imports"));
    retval.insert(QLatin1String("apply-templates"));
    retval.insert(QLatin1String("attribute"));
    retval.insert(QLatin1String("attribute-set"));
    retval.insert(QLatin1String("call-template"));
    retval.insert(QLatin1String("character-map"));
    retval.insert(QLatin1String("choose"));
    retval.insert(QLatin1String("comment"));
    retval.insert(QLatin1String("copy"));
    retval.insert(QLatin1String("copy-of"));
    retval.insert(QLatin1String("document"));
    retval.insert(QLatin1String("element"));
    retval.insert(QLatin1String("fallback"));
    retval.insert(QLatin1String("for-each"));
    retval.insert(QLatin1String("for-each-group"));
    retval.insert(QLatin1String("if"));
    retval.insert(QLatin1String("message"));
    retval.insert(QLatin1String("namespace"));
    retval.insert(QLatin1String("next-match"));
    retval.insert(QLatin1String("number"));
    retval.insert(QLatin1String("perform-sort"));
    retval.insert(QLatin1String("processing-instruction"));
    retval.insert(QLatin1String("result-document"));
    retval.insert(QLatin1String("sequence"));
    retval.insert(QLatin1String("text"));
    retval.insert(QLatin1String("variable"));

    Q_ASSERT(retval.count() == StringSetSize);
    return retval;
}

bool ElementAvailableFN::evaluateEBV(const DynamicContext::Ptr &context) const
{
    const Item arg(m_operands.first()->evaluateSingleton(context));
    const QString stringName(arg.stringValue());

    const QXmlName elementName(QNameConstructor::expandQName<DynamicContext::Ptr,
                                                             ReportContext::XTDE1440,
                                                             ReportContext::XTDE1440>(stringName,
                                                                                      context,
                                                                                      staticNamespaces(),
                                                                                      this,
                                                                                      false));

    if(elementName.namespaceURI() != StandardNamespaces::xslt)
        return false;

    QString prefix;
    QString localName;
    XPathHelper::splitQName(stringName, prefix, localName);

    return m_xsltInstructions.contains(localName);
}

QT_END_NAMESPACE
