/****************************************************************************
**
** Copyright (C) 2008-$THISYEAR$ $TROLLTECH$. All rights reserved.
**
** This file is part of the $MODULE$ of the Qt Toolkit.
**
** $TROLLTECH_DUAL_LICENSE$
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QHILDONINPUTCONTEXT_P_H
#define QHILDONINPUTCONTEXT_P_H

#include "QtGui/qinputcontext.h"
#include "qhildoninputmethodprotocol.h"

#ifdef Q_WS_HILDON

QT_BEGIN_HEADER

QT_MODULE(Gui)

class QHildonInputContext : public QInputContext
{
    Q_OBJECT
public:
    explicit QHildonInputContext(QObject* parent = 0);
    ~QHildonInputContext();

    QString identifierName();
    QString language();
    void reset();
    bool isComposing() const;
    void setFocusWidget(QWidget *w);
    bool eventFilter(QObject *obj, QEvent *event);
    void setInputMode(int mode);
    void update();

protected:
    void toggleHildonMainIMUi();
    void timerEvent(QTimerEvent *);

    //Filters
    bool filterKeyPress(QWidget *w,QKeyEvent *ev);
    bool x11FilterEvent(QWidget *keywidget, XEvent *event);

private:
    bool canUseIM(QWidget *w);
    void insertUtf8(int flag, const QString& text);
    void clearSelection();

    void sendHildonCommand(HildonIMCommand cmd, QWidget *widget=0);
    void sendX11Event(XEvent *event);
    void showHIMMainUI();

    //Context
    void checkSentenceStart();
    void commitPreeditData();
    void checkCommitMode(); //### REMOVE?
    void sendSurrounding();
    void sendSurroundingHeader(int offset);
    void inputModeChanged();
    void setClientCursorLocation(int offsetIsRelative, int cursorOffset); //FIXME?? Move offsetIsRelative to Bool?

    //Vars
    int timerId;
    int mask;
    int options;
    HildonIMTrigger triggerMode;
    HildonIMCommitMode commitMode;
    int inputMode;
    QString preEditBuffer;
    QString surrounding;
    int textCursorPosOnPress; //position of the cursor in the surrounding text at the last TabletPress event
    bool autoUpper;
    bool lastInternalChange;
};

QT_END_HEADER

#endif // Q_WS_HILDON

#endif //QHILDONINPUTCONTEXT_P_H
