/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "SVGElement.h"
#include "JSSVGPointList.h"

#include <wtf/GetPtr.h>

#include "SVGPointList.h"

#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGPointList)

/* Hash table */

static const HashTableValue JSSVGPointListTableValues[2] =
{
    { "numberOfItems", DontDelete|ReadOnly, (intptr_t)jsSVGPointListNumberOfItems, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGPointListTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGPointListTableValues, 0 };
#else
    { 2, 1, JSSVGPointListTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSSVGPointListPrototypeTableValues[8] =
{
    { "clear", DontDelete|Function, (intptr_t)jsSVGPointListPrototypeFunctionClear, (intptr_t)0 },
    { "initialize", DontDelete|Function, (intptr_t)jsSVGPointListPrototypeFunctionInitialize, (intptr_t)1 },
    { "getItem", DontDelete|Function, (intptr_t)jsSVGPointListPrototypeFunctionGetItem, (intptr_t)1 },
    { "insertItemBefore", DontDelete|Function, (intptr_t)jsSVGPointListPrototypeFunctionInsertItemBefore, (intptr_t)2 },
    { "replaceItem", DontDelete|Function, (intptr_t)jsSVGPointListPrototypeFunctionReplaceItem, (intptr_t)2 },
    { "removeItem", DontDelete|Function, (intptr_t)jsSVGPointListPrototypeFunctionRemoveItem, (intptr_t)1 },
    { "appendItem", DontDelete|Function, (intptr_t)jsSVGPointListPrototypeFunctionAppendItem, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGPointListPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 63, JSSVGPointListPrototypeTableValues, 0 };
#else
    { 18, 15, JSSVGPointListPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGPointListPrototype::s_info = { "SVGPointListPrototype", 0, &JSSVGPointListPrototypeTable, 0 };

JSObject* JSSVGPointListPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSSVGPointList>(exec);
}

bool JSSVGPointListPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGPointListPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGPointList::s_info = { "SVGPointList", 0, &JSSVGPointListTable, 0 };

JSSVGPointList::JSSVGPointList(PassRefPtr<Structure> structure, PassRefPtr<SVGPointList> impl, SVGElement* context)
    : DOMObject(structure)
    , m_context(context)
    , m_impl(impl)
{
}

JSSVGPointList::~JSSVGPointList()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSSVGPointList::createPrototype(ExecState* exec)
{
    return new (exec) JSSVGPointListPrototype(JSSVGPointListPrototype::createStructure(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSSVGPointList::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGPointList, Base>(exec, &JSSVGPointListTable, this, propertyName, slot);
}

JSValuePtr jsSVGPointListNumberOfItems(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGPointList* imp = static_cast<SVGPointList*>(static_cast<JSSVGPointList*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->numberOfItems());
}

JSValuePtr jsSVGPointListPrototypeFunctionClear(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGPointList::s_info))
        return throwError(exec, TypeError);
    JSSVGPointList* castedThisObj = static_cast<JSSVGPointList*>(asObject(thisValue));
    return castedThisObj->clear(exec, args);
}

JSValuePtr jsSVGPointListPrototypeFunctionInitialize(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGPointList::s_info))
        return throwError(exec, TypeError);
    JSSVGPointList* castedThisObj = static_cast<JSSVGPointList*>(asObject(thisValue));
    return castedThisObj->initialize(exec, args);
}

JSValuePtr jsSVGPointListPrototypeFunctionGetItem(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGPointList::s_info))
        return throwError(exec, TypeError);
    JSSVGPointList* castedThisObj = static_cast<JSSVGPointList*>(asObject(thisValue));
    return castedThisObj->getItem(exec, args);
}

JSValuePtr jsSVGPointListPrototypeFunctionInsertItemBefore(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGPointList::s_info))
        return throwError(exec, TypeError);
    JSSVGPointList* castedThisObj = static_cast<JSSVGPointList*>(asObject(thisValue));
    return castedThisObj->insertItemBefore(exec, args);
}

JSValuePtr jsSVGPointListPrototypeFunctionReplaceItem(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGPointList::s_info))
        return throwError(exec, TypeError);
    JSSVGPointList* castedThisObj = static_cast<JSSVGPointList*>(asObject(thisValue));
    return castedThisObj->replaceItem(exec, args);
}

JSValuePtr jsSVGPointListPrototypeFunctionRemoveItem(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGPointList::s_info))
        return throwError(exec, TypeError);
    JSSVGPointList* castedThisObj = static_cast<JSSVGPointList*>(asObject(thisValue));
    return castedThisObj->removeItem(exec, args);
}

JSValuePtr jsSVGPointListPrototypeFunctionAppendItem(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGPointList::s_info))
        return throwError(exec, TypeError);
    JSSVGPointList* castedThisObj = static_cast<JSSVGPointList*>(asObject(thisValue));
    return castedThisObj->appendItem(exec, args);
}

JSC::JSValuePtr toJS(JSC::ExecState* exec, SVGPointList* object, SVGElement* context)
{
    return getDOMObjectWrapper<JSSVGPointList>(exec, object, context);
}
SVGPointList* toSVGPointList(JSC::JSValuePtr value)
{
    return value->isObject(&JSSVGPointList::s_info) ? static_cast<JSSVGPointList*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
