#include "retrieveurlsdialog.h"
#include "../shared/urlretriever.h"
#include "../shared/settings.h"
#include "../shared/database.h"
#include <QTextEdit>
#include <QLabel>
#include <QDialogButtonBox>
#include <QPushButton>
#include <QVBoxLayout>
#include <QFile>
#include <QDropEvent>

RetrieveUrlsDialog::RetrieveUrlsDialog(QWidget *parent) :
    QDialog(parent),
    m_urlsEdit(new QTextEdit(this)),
    m_buttonBox(new QDialogButtonBox(QDialogButtonBox::Ok | QDialogButtonBox::Cancel, Qt::Horizontal, this)),
    m_vbox(new QVBoxLayout(this))
{
    this->setWindowTitle(tr("Retrieve URLs"));
    this->setAttribute(Qt::WA_DeleteOnClose, true);
    this->setMinimumSize(500, 300);
    this->setAcceptDrops(true);

    m_vbox->addWidget(m_urlsEdit);
    m_vbox->addWidget(m_buttonBox);

    this->connect(m_urlsEdit, SIGNAL(textChanged()), this, SLOT(onTextChanged()));
    this->connect(m_buttonBox, SIGNAL(accepted()), this, SLOT(parseUrls()));
    this->connect(m_buttonBox, SIGNAL(rejected()), this, SLOT(reject()));
}

RetrieveUrlsDialog::~RetrieveUrlsDialog() {}

void RetrieveUrlsDialog::dragEnterEvent(QDragEnterEvent *event) {
    if ((event->mimeData()->hasUrls()) && (event->mimeData()->urls().first().path().toLower().endsWith(".txt"))) {
        event->acceptProposedAction();
    }
}

void RetrieveUrlsDialog::dropEvent(QDropEvent *event) {
    if (event->mimeData()->hasUrls()) {
        QString fileName = event->mimeData()->urls().first().path();

        if ((QFile::exists(fileName)) && (fileName.toLower().endsWith(".txt"))) {
            this->parseUrlsFromTextFile(fileName);
        }
    }
}

QString RetrieveUrlsDialog::text() const {
    return m_urlsEdit->toPlainText();
}

void RetrieveUrlsDialog::setText(const QString &text) {
    m_urlsEdit->setText(text);
}

void RetrieveUrlsDialog::parseUrlsFromTextFile(const QString &fileName) {
    QFile file(fileName);

    if (file.open(QIODevice::ReadOnly | QIODevice::Text)) {
        while (!file.atEnd()) {
            QUrl url(file.readLine());

            if (url.isValid()) {
                m_urlsEdit->insertPlainText(url.toString());
            }
        }

        file.close();
    }
}

void RetrieveUrlsDialog::onTextChanged() {
    m_buttonBox->button(QDialogButtonBox::Ok)->setEnabled(!m_urlsEdit->toPlainText().isEmpty());
}

void RetrieveUrlsDialog::parseUrls() {
    UrlRetriever::instance()->parseUrlsFromText(m_urlsEdit->toPlainText());
    this->accept();
}
