#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>

class QLineEdit;
class QComboBox;
class CheckUrlsDialog;
class QTreeView;
class QMenu;
class QActionGroup;
class QToolButton;
class QLabel;
class QProgressDialog;
class TransferModel;

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

protected:
    bool event(QEvent *event);
    void keyPressEvent(QKeyEvent *event);
    void showEvent(QShowEvent *event);

private slots:
    void setFullScreen(bool fullScreen);
    void onPluginsReady();
    void onPackageCountChanged(int count);
    void setNextAction();
    void setTransferStatusFilter();
    void setMaximumConcurrentTransfers();
    void setGlobalTransferConnections();
    void setDownloadRateLimit();
    void updateSpeed(int speed);
    void setTransferMenuActions();
    void setPackageMenuActions();
    void setCategoryMenuActions();
    void showContextMenu(const QPoint &pos);
    void showCurrentTransferProperties();
    void setConvertCurrentTransferToAudio();
    void startCurrentTransfer();
    void pauseCurrentTransfer();
    void removeCurrentTransfer();
    void setCurrentTransferConnections();
    void setCurrentTransferCategory();
    void setCurrentTransferPriority();
    void showCurrentPackageProperties();
    void startCurrentPackage();
    void pauseCurrentPackage();
    void removeCurrentPackage();
    void setCurrentPackageCategory();
    void setCurrentPackagePriority();
    void showAddUrlsDialog(const QString &text = QString(), const QString &fileName = QString());
    void showRetrieveUrlsDialog(const QString &text = QString(), const QString &fileName = QString());
    void onUrlRetrieverFinished();
    void showTextFileDialog();
    void showAboutDialog();
    void showSettingsDialog();
    void showProgressDialog(const QString &message, int maximum = 100);
    void updateProgressDialog(int progress);
    void hideProgressDialog();
    
private:
    QToolBar *m_toolBar;
    QAction *m_addUrlsAction;
    QAction *m_importUrlsAction;
    QAction *m_retrieveUrlsAction;
    QAction *m_startAction;
    QAction *m_pauseAction;
    QLineEdit *m_searchEdit;
    QMenu *m_transferMenu;
    QAction *m_transferPropertiesAction;
    QAction *m_transferConvertToAudioAction;
    QAction *m_transferStartAction;
    QAction *m_transferPauseAction;
    QMenu *m_transferConnectionsMenu;
    QActionGroup *m_transferConnectionsGroup;
    QMenu *m_transferCategoryMenu;
    QActionGroup *m_transferCategoryGroup;
    QMenu *m_transferPriorityMenu;
    QActionGroup *m_transferPriorityGroup;
    QAction *m_transferHighPriorityAction;
    QAction *m_transferNormalPriorityAction;
    QAction *m_transferLowPriorityAction;
    QAction *m_transferRemoveAction;
    QMenu *m_packageMenu;
    QAction *m_packagePropertiesAction;
    QAction *m_packageStartAction;
    QAction *m_packagePauseAction;
    QMenu *m_packageCategoryMenu;
    QActionGroup *m_packageCategoryGroup;
    QMenu *m_packagePriorityMenu;
    QActionGroup *m_packagePriorityGroup;
    QAction *m_packageHighPriorityAction;
    QAction *m_packageNormalPriorityAction;
    QAction *m_packageLowPriorityAction;
    QAction *m_packageRemoveAction;
    QMenu *m_optionsMenu;
    QMenu *m_transferStatusFilterMenu;
    QAction *m_allFilterAction;
    QAction *m_downloadingFilterAction;
    QAction *m_queuedFilterAction;
    QAction *m_waitingFilterAction;
    QAction *m_pausedFilterAction;
    QAction *m_failedFilterAction;
    QActionGroup *m_transferStatusFilterGroup;
    QMenu *m_nextActionMenu;
    QAction *m_continueNextAction;
    QAction *m_pauseNextAction;
    QAction *m_quitNextAction;
    QActionGroup *m_nextActionGroup;
    QMenu *m_concurrentMenu;
    QActionGroup *m_concurrentGroup;
    QMenu *m_connectionsMenu;
    QActionGroup *m_connectionsGroup;
    QMenu *m_rateLimitMenu;
    QActionGroup *m_rateLimitGroup;
    QMenu *m_viewMenu;
    QAction *m_fullscreenAction;
    QAction *m_preferencesAction;
    QAction *m_aboutAction;
    QAction *m_quitAction;
    QLabel *m_speedLabel;
    TransferModel *m_model;
    QTreeView *m_view;
    CheckUrlsDialog *m_checkDialog;
    QProgressDialog *m_progressDialog;
    bool m_progressDialogHasCancelButton;
};

#endif // MAINWINDOW_H
