#ifndef CATEGORYSETTINGSTAB_H
#define CATEGORYSETTINGSTAB_H

#include <QWidget>

class CategoriesModel;
class QTreeView;
class QMenu;
class QPushButton;

class CategorySettingsTab : public QWidget
{
    Q_OBJECT

public:
    explicit CategorySettingsTab(QWidget *parent = 0);

private slots:
    void showContextMenu(const QPoint &pos);
    void addCategory();
    void removeCategory();
    void editCategory();
    
private:
    CategoriesModel *m_model;
    QTreeView *m_view;
    QMenu *m_contextMenu;
    QAction *m_editAction;
    QAction *m_removeAction;
    QPushButton *m_newButton;
};

#endif // CATEGORYSETTINGSTAB_H
