import dbus
import osso
from dbus.mainloop.glib import DBusGMainLoop
DBusGMainLoop(set_as_default=True)

##Class to manage N810 screen
class ScreenManager():
	##constructor
	def __init__(self, onScreenOffCallback=None, onScreenOnCallback=None, onScreenDimmedCallback=None):
		#set members
		self.__onScreenOnCallback = onScreenOnCallback
		self.__onScreenOffCallback = onScreenOffCallback
		self.__onScreenDimmedCallback = onScreenDimmedCallback
		self.__screen = None
		
		#init context
		self.__context = osso.Context("ScreenManager", "0.0.1", False)
		self.__device = osso.DeviceState(self.__context)
		
		#init dbus
		self.__dbus = dbus.SystemBus(private=True)
		object = self.__dbus.get_object('com.nokia.mce', '/com/nokia/mce/signal')
		interface = dbus.Interface(object, 'com.nokia.mce.signal')
		interface.connect_to_signal('display_status_ind', self.__handler)
	
	##screen dbus messages handler
	def __handler(self, sender=None):
		status = "%s" % (sender,)
		if status=='on' and self.__onScreenOnCallback!=None:
			self.__onScreenOnCallback()
		elif status=='off' and self.__onScreenOffCallback!=None:
			self.__onScreenOffCallback()
		elif status=='dimmed' and self.__onScreenDimmedCallback!=None:
			self.__onScreenDimmedCallback()
			
	##Request to turn on the display as if the user had pressed a key or the
	##touch screen. This can be used after completing a long operation such as
	##downloading a large file or after retrieving e-mails
	def turnScreenOn(self):
		if self.__device!=None:
			self.__device.display_state_on()
			
	##Request not to blank the display. This method must be called again
	##within 60 seconds to renew the request. The method is used, for
	##example, by the video player during video playback. Alson prevents
	##suspending the device.
	def turnScreenOnDuring60Seconds(self):
		if self.__device!=None:
			self.__device.display_blanking_pause()

