import gpsbt
import threading
import time

##GPS Manager Exception class
class GpsManagerException(Exception):
	#constructor
	def __init__(self, message):
		self.message = message
	
	#tostring
	def __str__(self):
		return 'GpsManagerException : ' + str(self.message)

##GPS Manager class
class GpsManager():
	#constants
	NaN = 1e10
	MODE_NO_FIX = 1
	MODE_2D = 2
	MODE_3D = 3
	#TIMEOUT_RESTART_GPS = 240 #seconds
	#FREEZE_MAX_COUNTER = 30
	
	##constructor
	def __init__(self):
		self.__context = None
		self.__gps = None
		self.__satellites = None
		self.__initTimer = None
		self.__fixTimer = None
		self.__startTime = 0
		#self.__satellitesDetected = False
		#self.__previousData = None
		#self.__freezeCounter = 0
		
	##destructor
	def __del__(self):
		self.stop()
		
	##Start gps device
	##@param onStartCallback : function called when GPS is started
	##@param onNeedRestartCallback : function called when GPS needs to be restarted (gpsd freezed, bad gpsd init...)
	##@param onFixCallback : function called when GPS is fixed
	def start(self, onStartCallback, onNeedRestartCallback=None, onFixCallback=None):
		#init members
		self.__context = gpsbt.start()
		self.__gps = None
		self.__onStartCallback = onStartCallback
		self.__onNeedRestartCallback = onNeedRestartCallback
		self.__onFixCallback = onFixCallback
		self.__startTime = time.time()
		
		if self.__context==None:
			raise GpsManagerException('Unable to get context (launch as root?)')
			self.stop()
			
		#init gps member after 2 seconds (time to start GPS daemon)
		self.__initTimer = threading.Timer(2.0, self.__initGps)
		self.__initTimer.start()
			
	##Stop gps device
	def stop(self):
		#stop timers
		if self.__initTimer!=None:
			#stop timer
			self.__initTimer.cancel()
			self.__initTimer = None
			
		if self.__fixTimer!=None:
			#stop timer
			self.__fixTimer.cancel()
			self.__fixTimer = None
			
		#stop gps device
		if self.__context:
			gpsbt.stop(self.__context)
		
	##init gps member
	def __initGps(self):
		if self.__context!=None:
			#get gps
			self.__gps = gpsbt.gps()
			
			#reset init timer
			self.__initTimer = None
			
			#launch onfix callback if necessary
			if self.__onFixCallback!=None:
				self.__fixTimer = threading.Timer(2.0, self.__fixGps)
				self.__fixTimer.start()
			
			#init ok, launch callback
			self.__onStartCallback()
			
	##gps is fixed ?
	def __fixGps(self):
		#get data
		data = self.getData()
		
		#check if gps is fixed
		if data!=None:
			#check if gps receives satellites infos
			#(sometimes gps device receives no infos and stay in bad state)
			#satellites = self.getSatellites()
			#if not self.__satellitesDetected and satellites!=None and len(satellites)==0:
			#	#check if we need to restart gps device
			#	diff = int(time.time() - self.__startTime)
			#	if diff>=self.TIMEOUT_RESTART_GPS:
			#		#timeout reached and no satellites detected by gps => device in bad state, need to restart it
			#		self.__onNeedRestartCallback()
			#		return
			#else:
			#	#satellites detected, device correctly initalized
			#	self.__satellitesDetected = True
		
			if data.mode==self.MODE_NO_FIX:
				#no fix yet, launch again this method
				self.__fixTimer = threading.Timer(1.0, self.__fixGps)
				self.__fixTimer.start()
			else:
				#gps is fixed, callback
				self.__fixTimer = None
				#launch callback
				if self.__onFixCallback!=None:
					self.__onFixCallback()
		else:
			#no data?
			raise GpsManagerException('Unable to get data')
			self.stop()
		
	##return fix data
	##data contains :
	## - mode : the NMEA mode (see class constants)
	## - time : timestamp
	## - ept 
	## - latitude
	## - longitude
	## - eph : horizontal precision (in meters)
	## - altitude
	## - epv : vertical precision (in meters)
	## - track (Degrees from true north) 
	## - speed (Meters per second)
	## - climb (Meters per second)
	## - epd : direction precision (in degrees)
	## - eps : speed precision (in m/s)
	## - epc : climb precision (in m/s)
	def getData(self):
		try:
			if self.__gps!=None:
				#request fix infos
				self.__gps.get_fix()
				data = self.__gps.fix
				
				#check if previous data is different from current one (based on lat/long/speed)
				#sometimes gpsd is freezed and always return same values
				#if self.__previousData!=None and self.__previousData.latitude==data.latitude and self.__previousData.longitude==data.longitude and self.__previousData.speed>=0.5555 and self.__previousData.speed==data.speed:
				#	#increase problem counter
				#	self.__freezeCounter += 1
				#else:
				#	#reset counter
				#	self.__freezeCounter = 0
				#
				#if self.__freezeCounter>=self.FREEZE_MAX_COUNTER:
				#	#gpsd is detected as freezed, restart now
				#	self.__onNeedRestartCallback()
				#	self.__freezeCounter = 0
					
				#	#failed
				#	return None
				
				#current data becomes previous data
				#self.__previousData = data
				
				#success
				return data
			else:
				#failed
				return None
		except Exception,e:
			#failed
			return None
			
	##Return satellites
	##data contains :
	## - PRN : satellite id
	## - E : Elevation (0-90)
	## - Az : Azimut (0-359)
	## - Ss : signal strength (in decibels)
	## - Used : satellite used during last fix (1 or 0)
	def getSatellites(self):
		try:
			if self.__gps!=None:
				#necessary ??
				self.__gps.get_fix()
				
				return self.__gps.satellites
			else:
				return None
		except:
			#failed
			return None
	
	##Return true if device is ready
	def isReady(self):
		if self.__context!=None and self.__gps!=None:
			return True
		else:
			return False

