import osso
import sys

class SystemManager():
	#members
	__context = None
	__device = None
	onSystemInactivityCallback = None
	onShutdownCallback = None
	onSaveDataCallback = None
	onMemoryLowCallback = None
	onModeChangeCallback = None
	previousSystemInactivity = False
	previousMode = ''
	previousShutdown = False
	previousSaveData = False
	previousMemoryLow = False
	firstTime = True
	
	#constructor
	def __init__(self, onSystemInactivityCallback=None, onModeChangeCallback=None, onSaveDataCallback=None, onShutdownCallback=None, onMemoryLowCallback=None):
		#set members
		self.onSystemInactivityCallback = onSystemInactivityCallback
		self.onShutdownCallback = onShutdownCallback
		self.onSaveDataCallback = onSaveDataCallback
		self.onMemoryLowCallback = onMemoryLowCallback
		self.onModeChangeCallback = onModeChangeCallback
		
		#init context
		self.__context = osso.Context("SystemManager", "0.0.1", False)
		self.__device = osso.DeviceState(self.__context)
		#set_device_callback(callback[, user_data[, shutdown[, save_data[, memory_low[, system_inactivity[, mode]]]]]
		#mode in ('normal', 'flight', 'invalid', 'offline')
		bSystemInactivity = False
		if self.onSystemInactivityCallback!=None:
			bSystemInactivity = True
		bShutdown = False
		if self.onShutdownCallback!=None:
			bShutdown = True
		bSaveData = False
		if self.onSaveDataCallback!=None:
			bSaveData = True
		bMemoryLow = False
		if self.onMemoryLowCallback!=None:
			bMemoryLow = True
		if self.onModeChangeCallback!=None:
			self.__device.set_device_state_callback(SystemManager.handler, user_data=self, shutdown=bShutdown, save_data=bSaveData, memory_low=bMemoryLow, system_inactivity=bSystemInactivity, mode="offline")
		else:
			self.__device.set_device_state_callback(SystemManager.handler, user_data=self, shutdown=bShutdown, save_data=bSaveData, memory_low=bMemoryLow, system_inactivity=bSystemInactivity)

	#destructor
	def __del__(self):
		if self.__device!=None:
			self.__device.set_device_state_callback(None)
			
	#screen dbus messages handler
	def handler(shutdown, save_data, memory_low, system_inactivity, mode, user_data):
		if user_data!=None or user_data.__class__.__name__!='SystemManager':
			if user_data.firstTime:
				#change flag
				user_data.firstTime = False
				#first time that handler is called, launch callbacks
				if user_data.onShutdownCallback!=None:
					user_data.onShutdownCallback(shutdown)
				if user_data.onSaveDataCallback!=None:
					user_data.onSaveDataCallback(save_data)
				if user_data.onMemoryLowCallback!=None:
					user_data.onMemoryLowCallback(memory_low)
				if user_data.onSystemInactivityCallback!=None:
					user_data.onSystemInactivityCallback(system_inactivity)
				if user_data.onModeChangeCallback!=None:
					user_data.onModeChangeCallback(mode)
			else:
				#it's not the first time, launch correct callbacks
				if user_data.previousShutdown!=shutdown and user_data.onShutdownCallback!=None:
					user_data.onShutdownCallback(shutdown)
				if user_data.previousSaveData!=save_data and user_data.onSaveDataCallback!=None:
					user_data.onSaveDataCallback(save_data)
				if user_data.previousMemoryLow!=memory_low and user_data.onMemoryLowCallback!=None:
					user_data.onMemoryLowCallback(memory_low)
				if user_data.previousSystemInactivity!=system_inactivity and user_data.onSystemInactivityCallback!=None:
					user_data.onSystemInactivityCallback(system_inactivity)
				if user_data.previousMode!=mode and user_data.onModeChangeCallback!=None:
					user_data.onModeChangeCallback(mode)
			
			#save current states
			user_data.previousSystemInactivity = system_inactivity
			user_data.previousMode = mode
			user_data.previousShutdown = shutdown
			user_data.previousSaveData = save_data
			user_data.previousMemoryLow = memory_low
		else:
			sys.stderr.write('SystemManager : user_data is not awaited object!\n')
	handler = staticmethod(handler)

if __name__ == "__main__":
	from dbus.mainloop.glib import DBusGMainLoop
	DBusGMainLoop(set_as_default=True)
	import gobject
	
	def onSystemInactivity(inactivity):
		if inactivity:
			print 'system is inactive'
		else:
			print 'system is active'
			
	def onSystemMode(mode):
		print 'system mode is "%s"' % mode
		
	def onSaveData(savedata):
		print 'save data : %s' % savedata

	dbus_loop = gobject.MainLoop()
	screen = SystemManager(onSystemInactivity, onSystemMode, onSaveData)
	dbus_loop.run()
