import dbus
import osso

class ScreenManager():
	#members
	__dbus = None
	__device = None
	__screen = None
	__onScreenOnCallback = None
	__onScreenOffCallback = None
	__onScreenDimmedCallback = None
	
	#constructor
	def __init__(self, onScreenOffCallback=None, onScreenOnCallback=None, onScreenDimmedCallback=None):
		#set members
		self.__onScreenOnCallback = onScreenOnCallback
		self.__onScreenOffCallback = onScreenOffCallback
		self.__onScreenDimmedCallback = onScreenDimmedCallback
		
		#init context
		self.__context = osso.Context("ScreenManager", "0.0.1", False)
		self.__device = osso.DeviceState(self.__context)
		
		#init dbus
		self.__dbus = dbus.SystemBus(private=True)
		object = self.__dbus.get_object('com.nokia.mce', '/com/nokia/mce/signal')
		interface = dbus.Interface(object, 'com.nokia.mce.signal')
		interface.connect_to_signal('display_status_ind', self.__handler)
	
	#screen dbus messages handler
	def __handler(self, sender=None):
		status = "%s" % (sender,)
		if status=='on' and self.__onScreenOnCallback!=None:
			self.__onScreenOnCallback()
		elif status=='off' and self.__onScreenOffCallback!=None:
			self.__onScreenOffCallback()
		elif status=='dimmed' and self.__onScreenDimmedCallback!=None:
			self.__onScreenDimmedCallback()
			
	#Request to turn on the display as if the user had pressed a key or the
	#touch screen. This can be used after completing a long operation such as
	#downloading a large file or after retrieving e-mails
	def turnScreenOn(self):
		if self.__device!=None:
			self.__device.display_state_on()
			
	#Request not to blank the display. This method must be called again
	#within 60 seconds to renew the request. The method is used, for
	#example, by the video player during video playback. Alson prevents
	#suspending the device.
	def turnScreenOnDuring60Seconds(self):
		if self.__device!=None:
			self.__device.display_blanking_pause()


if __name__ == "__main__":
	from dbus.mainloop.glib import DBusGMainLoop
	DBusGMainLoop(set_as_default=True)
	import gobject
	import datetime
	
	screen = None
	
	def onScreenOn():
		now = datetime.datetime.now()
		print '%s : screen on' % (now.strftime('%Y-%m-%d %H:%M:%S'))
		
	def onScreenDimmed():
		now = datetime.datetime.now()
		print '%s : screen dimmed' % (now.strftime('%Y-%m-%d %H:%M:%S'))
	
	def onScreenOff():
		global screen
		now = datetime.datetime.now()
		print '%s : screen off, turn on in 10 seconds' % (now.strftime('%Y-%m-%d %H:%M:%S'))
		gobject.timeout_add(10000, screen.turnScreenOn)

	dbus_loop = gobject.MainLoop()
	screen = ScreenManager(onScreenOff, onScreenOn, onScreenDimmed)
	dbus_loop.run()
