import gpsbt
import threading

#------------------------------
# GPS Manager Exception class
#------------------------------
class GpsManagerException(Exception):
	#constructor
	def __init__(self, message):
		self.message = message
	
	#tostring
	def __str__(self):
		return 'GpsManagerException : ' + str(message)

#------------------------------
# GPS Manager class
#------------------------------
class GpsManager():
	#constants
	NaN = 1e10
	MODE_NO_FIX = 1
	MODE_2D = 2
	MODE_3D = 3
	
	#members
	__context = None
	__gps = None
	__initTimer = None
	__fixTimer = None

	#constructor
	def __init__(self):
		pass
		
	#destructor
	def __del__(self):
		self.stop()
		
	#start gps device
	#@param onStartCallback : function called when GPS is started
	#@param onFixCallback : function called when GPS is fixed
	def start(self, onStartCallback, onFixCallback=None):
		#init members
		self.__context = gpsbt.start()
		self.__gps = None
		
		if self.__context==None:
			raise GpsDeviceException('Unable to get context (launch as root?)')
			self.stop()
			
		#init gps member after 2 seconds (time to start GPS daemon)
		self.__initTimer = threading.Timer(2.0, self.__initGps, [onStartCallback])
		self.__initTimer.start()
		
		#launch onfix callback if necessary
		if onFixCallback!=None:
			self.__fixTimer = threading.Timer(2.0, self.__fixGps, [onFixCallback])
			self.__fixTimer.start()
			
	#stop gps device
	def stop(self):
		#stop timers
		if self.__initTimer!=None:
			self.__initTimer.cancel()
			self.__initTimer = None
		if self.__fixTimer!=None:
			self.__fixTimer.cancel()
			self.__fixTimer = None
			
		#stop gps device
		if self.__context:
			gpsbt.stop(self.__context)
		
	#init gps member
	def __initGps(self, onStartCallback):
		if self.__context!=None:
			#get gps
			self.__gps = gpsbt.gps()
			
			#reset init timer
			self.__initTimer = None
			
			#init ok, launch callback
			onStartCallback()
			
	#gps is fixed ?
	def __fixGps(self, onFixCallback):
		#get data
		data = self.getData()
		
		#check if gps is fixed
		if data!=None:
			if data.mode==GpsDevice.MODE_NO_FIX:
				#no fix yet, launch again this method
				self.__fixTimer = threading.Timer(1.0, self.__fixGps, [onFixCallback])
				self.__fixTimer.start()
			else:
				#gps is fixed, callback
				self.__fixTimer = None
				onFixCallback()
		else:
			#no data?
			raise GpsManagerException('Unable to get data')
			self.stop()
		
	#return fix data
	#data format:
	# - mode
	# - time
	# - ept
	# - latitude
	# - longitude
	# - eph
	# - altitude
	# - epv
	# - track (Degrees from true north)
	# - speed (Meters per second)
	# - climb (Meters per second)
	# - epd
	# - eps
	# - epc
	def getData(self):
		if self.__gps!=None:
			#request fix infos
			self.__gps.get_fix()
			
			#success
			return self.__gps.fix
		else:
			#failed
			return None
	
	#return true if device is ready
	def isReady(self):
		if self.__context!=None and self.__gps!=None:
			return True
		else:
			return False
			
if __name__ == "__main__":
	class GpsManagerTest():
		def __init__(self):
			self.gps = GpsManager()
			self.gps.start(self.onStart, self.onFix)
			self.counter = 0
	
		def printPosition(self):
			data = self.gps.getData()
			if data!=None:
				print 'lat=%.5f long=%.5f' % (data.latitude, data.longitude)
			else:
				print 'lat=? long=?'
			#print again position
			if self.counter<=20:
				self.counter += 1
				threading.Timer(1.0, self.printPosition).start()
			else:
				#max counter reached stop gps
				self.gps.stop()
				print 'gps stopped'
			
		def onFix(self):
			print 'GPS is fixed'
			self.printPosition()
	
		def onStart(self):
			print 'GPS started'
		
	test = GpsManagerTest()
	
	