#!/usr/bin/python

import gtk
import hildon
import sys

sys.path.append(r'/usr/share/pyconverter')
import converter

class GtkHildonConverter(hildon.Program):

	def main(self):
		gtk.main()

	def move_cursor(self, entry):
		entry.set_position(-1)
		return gtk.FALSE

	def entryValidator(self, entry, new_text, new_text_length, position):
		# got this code from http://www.daa.com.au/pipermail/pygtk/2003-June/005312.html
		# it complains about "entry.handler_block(hid)", but seems to work still
		if new_text.isdigit() or new_text == '.':
			string = entry.get_chars(0, -1) + new_text
			hid = entry.get_data('handlerid')
			entry.handler_block(hid)
			pos = entry.get_position()
			move = True
			try:
				val = float(string)
				pos = entry.insert_text(new_text, pos)
			except StandardError, e:
				print 'exception: %s' % e
			entry.handler_unblock(hid)
			gtk.idle_add(self.move_cursor, entry)
		entry.stop_emission('insert-text')

	def __init__(self):
		hildon.Program.__init__(self)

		# create a window
		self.win = hildon.Window()
		gtk.set_application_name('Unit Converter v0.1 - GTK/Hildon')
		self.add_window(self.win)
		self.win.connect('destroy', gtk.main_quit)

		# create a table to hold everything
		self.table = gtk.Table(rows=6, columns=2, homogeneous=True)
		self.win.add(self.table)

		# instantiate conversion engine
		self.changing = False
		self.converter = converter.Converter(r'/usr/share/pyconverter')
#		self.converter = converter.Converter('.')

		# first row, conversion types
			# create label
		types_label = gtk.Label('Conversion Type:')
		types_label.set_justify(gtk.JUSTIFY_RIGHT)
			# create combo box
		self.types = gtk.combo_box_new_text()
		for i in self.converter.getTypeList():
			self.types.append_text(i)
		self.types.connect('changed', self.loadFromToPick)
			# add to table
		self.table.attach(types_label, 0, 1, 0, 1)
		self.table.attach(self.types, 1, 2, 0, 1)

		# second/third row, conversion 'from'
			# create combo box
		self.conv_f = gtk.combo_box_new_text()
		self.conv_f.connect('changed', self.updateResults)
			# create entry box
		self.data_f = gtk.Entry()
		self.data_f.connect('insert-text', self.entryValidator)
#		self.data_f.setValidator(QDoubleValidator(self.data_f))
			# add to table
		self.table.attach(gtk.Label('From:'), 0, 1, 1, 2)
		self.table.attach(self.conv_f, 1, 2, 1, 2)
		self.table.attach(self.data_f, 0, 2, 2, 3)

		# fourth/fifth row, conversion 'to'
			# create combo box
		self.conv_t = gtk.combo_box_new_text()
		self.conv_t.connect('changed', self.updateResults)
			# create results label
		self.data_t = gtk.Label('?')
			# add to table
		self.table.attach(gtk.Label('To:'), 0, 1, 3, 4)
		self.table.attach(self.conv_t, 1, 2, 3, 4)
		self.table.attach(self.data_t, 0, 2, 4, 5)

		# sixth row, conversion button
			# create button
		btn_ok = gtk.Button('Convert')
		btn_ok.connect('clicked', self.doConversion)
			# add to table
		self.table.attach(btn_ok, 0, 2, 5, 6)

		# display everything
		self.types.set_active(0)
		self.win.show_all()

	def doConversion(self, param):
		# abort if we're changing the type
		if self.changing:
			return

		# get the list of units
		list = self.converter.getUnitList()

		# get the string for 'from' and 'to'
		old = list[self.conv_f.get_active()]
		new = list[self.conv_t.get_active()]

		# get the value
		val = self.data_f.get_text()

		# update the result
		self.data_t.set_label(self.converter.doConversion(old, new, val))

	def updateResults(self, cbox):
		self.doConversion(cbox)

	def loadFromToPick(self, cbox):
		# keep the changing pickers from triggering their signals
		self.changing = True

		# get the choices
		self.converter.setType(cbox.get_active())
		pick = self.converter.getUnitList()

		# update the 'from' picker
		self.conv_f.get_model().clear()
		for i in pick:
			self.conv_f.append_text(i)
		self.conv_f.set_active(0)

		# update the 'to' picker
		self.conv_t.get_model().clear()
		for i in pick:
			self.conv_t.append_text(i)
		self.conv_t.set_active(1)

		# okay, back to normal
		self.changing = False
		self.doConversion(0)

# run the program
if __name__ == '__main__':
	app = GtkHildonConverter()
	app.main()
