#! /usr/bin/env ruby

#
# $Id$
#
# Pref game test models
#

require 'test/unit'
require 'model/pref_calc_scores'
require 'model/pref_calc_model_variants'

module Tests

  class TS_Test4Players < Test::Unit::TestCase
    def setup
      @game = Game.new(Leningrad.new, ['p1','p2','p3', 'p4'])
      @scores = GameScores.new(@game)
    end

    # def teardown
    # end

    def assert_player(idx, p, m, w0, w1, w2, w3)
      assert_equal(p,  @scores.player_scores[idx].pool_value, "Player #{idx} expected to have #{p} in pool")
      assert_equal(m,  @scores.player_scores[idx].mount_value, "Player #{idx} expected to have #{m} in mount")
      assert_equal(w0, @scores.player_scores[idx].whists_value(0), "Player #{idx} expected to have #{w0} in whists[0]")
      assert_equal(w1, @scores.player_scores[idx].whists_value(1), "Player #{idx} expected to have #{w1} in whists[1]")
      assert_equal(w2, @scores.player_scores[idx].whists_value(2), "Player #{idx} expected to have #{w2} in whists[2]")
      assert_equal(w2, @scores.player_scores[idx].whists_value(3), "Player #{idx} expected to have #{w3} in whists[2]")
    end

    def test_positive1
      # Game 6, played, 2 "standing" whisters took 2+2
      @game.append(GameModel::HandResult::Positive.new(@game, 3, 0, 0, 6, 0, 2, 2, true, true))
      assert_player(0, 2, 0, 0, 0, 0, 0)
      assert_player(1, 0, 0, 8, 0, 0, 0)
      assert_player(2, 0, 0, 8, 0, 0, 0)
      assert_player(3, 0, 0, 0, 0, 0, 0)
    end

    def test_positive2
      # Game 6, played, 1 "standing" whister, took 3+1
      # 2 - dealer
      # 1 - bid winner
      # 3 took 3 (standing)
      # 0 took 1
      @game.append(GameModel::HandResult::Positive.new(@game, 2, 0, 0, 6, 1, 3, 1, true, false))
      assert_player(0, 0, 0, 0, 0, 0, 0)
      assert_player(1, 2, 0, 0, 0, 0, 0)
      assert_player(2, 0, 0, 0, 0, 0, 0)
      assert_player(3, 0, 0, 0, 16, 0, 0)
    end

    def test_positive3
      # Game 6, played as 7, 2 "standing" whisters, took 1 and 2
      @game.append(GameModel::HandResult::Positive.new(@game, 3, 0, 0, 6, 0, 1, 2, true, true))
      assert_player(0, 2, 0, 0, 0, 0, 0)
      assert_player(1, 0, 2, 4, 0, 0, 0)
      assert_player(2, 0, 0, 8, 0, 0, 0)
      assert_player(3, 0, 0, 0, 0, 0, 0)
    end

    def test_positive4
      # Game 6, played as 7, 1 "standing" whister, took 2+1
      @game.append(GameModel::HandResult::Positive.new(@game, 3, 0, 0, 6, 0, 2, 1, true, false))
      assert_player(0, 2, 0, 0, 0, 0, 0)
      assert_player(1, 0, 2, 12, 0, 0, 0)
      assert_player(2, 0, 0, 0, 0, 0, 0)
      assert_player(3, 0, 0, 0, 0, 0, 0)
    end

    def test_positive5
      # Game 6, played as 5, 1 "standing" whister, took 5
      @game.append(GameModel::HandResult::Positive.new(@game, 3, 0, 0, 6, 0, 5, 0, true, false))
      assert_player(0, 0, 4, 0, 0, 0, 0)
      assert_player(1, 0, 0, 12, 0, 0, 0)
      assert_player(2, 0, 0, 12, 0, 0, 0)
      assert_player(3, 0, 0, 0, 0, 0, 0)
    end

    def test_positive6
      # Game 6, played as 5, 2 "standing" whisters, took 3+2
      @game.append(GameModel::HandResult::Positive.new(@game, 3, 0, 0, 6, 0, 3, 2, true, true))
      assert_player(0, 0, 4, 0, 0, 0, 0)
      assert_player(1, 0, 0, 16, 0, 0, 0)
      assert_player(2, 0, 0, 12, 0, 0, 0)
      assert_player(3, 0, 0, 0, 0, 0, 0)
    end

    def test_positive7
      # Game 7, played, 2 "standing" whisters, took 1+2
      @game.append(GameModel::HandResult::Positive.new(@game, 3, 0, 0, 7, 0, 1, 2, true, true))
      assert_player(0, 4, 0, 0, 0, 0, 0)
      assert_player(1, 0, 0, 8, 0, 0, 0)
      assert_player(2, 0, 0, 16, 0, 0, 0)
      assert_player(3, 0, 0, 0, 0, 0, 0)
    end

    def test_positive8
      # Game 7, played, 1 "standing" whisters, took 1+2
      @game.append(GameModel::HandResult::Positive.new(@game, 3, 0, 0, 7, 0, 1, 2, true, false))
      assert_player(0, 4, 0, 0, 0, 0, 0)
      assert_player(1, 0, 0, 24, 0, 0, 0)
      assert_player(2, 0, 0, 0, 0, 0, 0)
      assert_player(3, 0, 0, 0, 0, 0, 0)
    end


    # Pass Out
    def test_pass_out1
      # Pass out dealt by #3, taken 0/4/3/3
      @game.append(GameModel::HandResult::PassOut.new(@game, 3, 0, 4, 3, 3))
      assert_player(0, 0, 8, 0, 0, 0, 0)
      assert_player(1, 0, 6, 0, 0, 0, 0)
      assert_player(2, 0, 6, 0, 0, 0, 0)
      assert_player(3, 0, 0, 0, 0, 0, 0)
    end

    def test_pass_out2
      # Pass out dealt by #2, taken 1/5/3/1
      @game.append(GameModel::HandResult::PassOut.new(@game, 2, 1, 5, 3, 1))
      assert_player(0, 0, 4, 0, 0, 0, 0)
      assert_player(1, 0, 0, 0, 0, 0, 0)
      assert_player(2, 0, 0, 0, 0, 0, 0)
      assert_player(3, 0, 8, 0, 0, 0, 0)
    end

    def test_pass_out3
      # Pass out dealt by #3, taken 2/5/3/0 - game for #2
      @game.append(GameModel::HandResult::PassOut.new(@game, 3, 2, 5, 3, 0))
      assert_player(0, 0, 10, 0, 0, 0, 0)
      assert_player(1, 0, 6, 0, 0, 0, 0)
      assert_player(2, 2, 0, 0, 0, 0, 0)
      assert_player(3, 0, 4, 0, 0, 0, 0)
    end

    # Mizere
    def test_mizere1
      # Mizere played ok
      @game.append(GameModel::HandResult::Mizere.new(@game, 3, 0, 0, 0, 0))
      assert_player(0, 10, 0, 0, 0, 0, 0)
      assert_player(1, 0, 0, 0, 0, 0, 0)
      assert_player(2, 0, 0, 0, 0, 0, 0)
      assert_player(3, 0, 0, 0, 0, 0, 0)
    end

    def test_mizere2
      # Mizere played ok
      @game.append(GameModel::HandResult::Mizere.new(@game, 3, 0, 0, 0, 3))
      assert_player(0, 0, 30, 0, 0, 0, 0)
      assert_player(1, 0, 0, 0, 0, 0, 0)
      assert_player(2, 0, 0, 0, 0, 0, 0)
      assert_player(3, 0, 0, 0, 0, 0, 0)
    end

  end

  require 'test/unit/ui/console/testrunner'
  Test::Unit::UI::Console::TestRunner.run(TS_Test4Players)

end
