require 'libglade2'

#
# $Id$
#
# GUI Utilities
#


$GETTEXT_DOMAIN = 'prefcalc'
$GETTEXT_LOCALEDIR = 'data/locale'

class PrefUtil
  include GetText

  def self.load_glade(name, dialog_obj)
    return GladeXML.new(@@glade_filename, name, $GETTEXT_DOMAIN, $GETTEXT_LOCALEDIR, GladeXML::FILE) do |handler|
      dialog_obj.methods.include?(handler) ? dialog_obj.method(handler) : nil
    end
  end

  def self.set_background_image(widget)
    widget.signal_connect("expose_event") do
      alloc = widget.allocation

      if (alloc.width > 0 and alloc.height > 0)
        cr = widget.window.create_cairo_context

        sx = alloc.width*1.0/@@bg_pixbuf.width
        sy = alloc.height*1.0/@@bg_pixbuf.height
        cr.translate(alloc.x, alloc.y)
        cr.scale(sx, sy)

        bgis = Cairo::ImageSurface.from_png(@@bg_png_path)
        cr.set_source(bgis, 0, 0)
        cr.paint
     end
      # Return false - proceed with the default expose handling
      false
    end
  end

  def self.background_pixbuf
    return @@bg_pixbuf
  end

  def self.background_png_path
    return @@bg_png_path
  end

  # Module loading

  # Init global vars
  @@glade_filename = nil
  @@bg_png_path = nil
  $GETTEXT_LOCALEDIR = nil
  $LOAD_PATH.each do |path|
    file_path = File.join(path, 'data/prefcalc/prefcalc.glade')
    if File.exist? file_path
      @@glade_filename = file_path
      @@bg_png_path = File.join(path, 'data/pixmaps/oldpaper.png')
      $GETTEXT_LOCALEDIR = File.join(path, 'data/locale')
      break
    end
  end

  # If not found - use system directories
  @@glade_filename = '/usr/share/prefcalc/prefcalc.glade' if @@glade_filename.nil?
  @@bg_png_path = '/usr/share/pixmaps/oldpaper.png' if @@bg_png_path.nil?
  $GETTEXT_LOCALEDIR = '/usr/share/locale' if $GETTEXT_LOCALEDIR.nil?

  @@bg_pixbuf = Gdk::Pixbuf.new(@@bg_png_path)
end

# Global binding
GetText.bindtextdomain($GETTEXT_DOMAIN, $GETTEXT_LOCALEDIR, nil, "UTF-8")


