#! /usr/bin/env ruby

#
# $Id$
#
# The totals view
#

require 'gtk2'

class PrefTotalsView < Gtk::HBox
  include GetText

  attr_reader :scores

  def initialize
    super(false, 12)

    PrefUtil::set_background_image(self)

    @scores = nil
  end

  def scores=(scores)
    @scores = scores
    @scores.game.add_listener(self) if scores

    vbox1 = Gtk::VBox.new
    vbox2 = Gtk::VBox.new
    vbox3 = Gtk::VBox.new
    # Remove all stuff
    each {|child| remove(child); }
    # Populate totals
    @score_lbls = Array.new
    @final_lbls = Array.new

    lbl = Gtk::Label.new
    lbl.set_markup(_('<b>Players</b>'))
    vbox1.pack_start(lbl)
    lbl = Gtk::Label.new
    lbl.set_markup(_('<b>Score</b>'))
    vbox2.pack_start(lbl)
    lbl = Gtk::Label.new
    lbl.set_markup(_('<b>Final</b>'))
    vbox3.pack_start(lbl)

    @scores.game.accounts.each do |acc| 
      vbox1.pack_start(Gtk::Label.new(acc.name), true, true, 6);
      lbl = Gtk::Label.new('0')
      @score_lbls.push(lbl)
      vbox2.pack_start(lbl, true, true, 6);
      lbl = Gtk::Label.new('0')
      @final_lbls.push(lbl)
      vbox3.pack_start(lbl, true, true, 6);
    end
    pack_start(vbox1, true, true, 12);
    pack_start(vbox2, true, true, 12);
    pack_start(vbox3, true, true, 12);

    show_all

    game_updated(nil)
  end

  def game_updated(hand_results)
    if @scores
      @scores.scores.each_with_index do |val, idx| 
        @score_lbls[idx].text = val.to_s
        if hand_results.nil?
          @final_lbls[idx].text = '0'
        else
          # Use comma as thousands separator
          final_val = (val * hand_results.game.whist_price).to_s
          parts = final_val.split('-')
          t2d = parts.last.reverse.scan(/.{1,3}/).join(',').reverse 
          t2d = '-' + t2d if parts.size == 2
          @final_lbls[idx].text = t2d
        end
      end
    end
  end
end
