require 'gtk2'
require 'pref_calc_actions'

#
# $Id$
#
# Toolbar
#


class PrefToolbar < Gtk::Toolbar
  include GetText

  def initialize
    super()

    tt = Gtk::Tooltips.new

    tbb_new=Gtk::ToolButton.new(Gtk::Stock::NEW);
    $action_game_new.add_button(tbb_new);
    tbb_new.set_tooltip(tt, _('New game'), nil)
    insert(-1, tbb_new);

    tbb_round=Gtk::ToolButton.new(Gtk::Stock::ADD);
    $action_round_new.add_button(tbb_round);
    tbb_round.set_tooltip(tt, _('Another round'), nil)
    insert(-1, tbb_round);

    insert(-1, Gtk::SeparatorToolItem.new());

    tbb_game=Gtk::ToolButton.new(Gtk::Stock::HOME);
    $action_page_game.add_button(tbb_game);
    tbb_game.set_tooltip(tt, _('View the main chart'), nil)
    insert(-1, tbb_game);

    tbb_totals=Gtk::ToolButton.new(Gtk::Stock::ZOOM_100);
    $action_page_totals.add_button(tbb_totals);
    tbb_totals.set_tooltip(tt, _('View totals'), nil)
    insert(-1, tbb_totals);

    tbb_history=Gtk::ToolButton.new(Gtk::Stock::INDEX);
    $action_page_history.add_button(tbb_history);
    tbb_history.set_tooltip(tt, _('View history'), nil)
    insert(-1, tbb_history);

    insert(-1, Gtk::SeparatorToolItem.new());

    tbb_about=Gtk::ToolButton.new(Gtk::Stock::ABOUT);
    $action_about.add_button(tbb_about);
    tbb_about.set_tooltip(tt, _('About'), nil)
    insert(-1, tbb_about);

    tbb_quit=Gtk::ToolButton.new(Gtk::Stock::QUIT);
    $action_quit.add_button(tbb_quit);
    tbb_quit.set_tooltip(tt, _('Quit'), nil)
    insert(-1, tbb_quit);

    self.toolbar_style = Gtk::Toolbar::Style::ICONS
    self.orientation = Gtk::ORIENTATION_VERTICAL;

    $action_round_new.sensitive = false
  end

end
