#! /usr/bin/env ruby

#
# $Id$
#
# The history view
#

require 'gtk2'

class PrefHistoryView < Gtk::HBox

  attr_reader :game

  def initialize
    super(false, 12)

    alg = Gtk::Alignment.new(0.5, 0.5, 1, 1)
    alg.set_padding(6, 6, 6, 6)
    pack_start(alg, true, true, 0);
    @list = Gtk::TreeView.new()
    @list.append_column(Gtk::TreeViewColumn.new("Game", Gtk::CellRendererText.new, :text => 0, :background => 1))
    @list.headers_visible = false
    scroll = Gtk::ScrolledWindow.new()
    scroll.set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC)
    scroll.add(@list)
    alg.add(scroll)

    @list.signal_connect('row-activated') { |wgt, path, col|
      $main_app_window.select_round_by_index(path.indices[0])
      $action_page_game.do
    }

    #Cannot set bg image for the treview, yet
    #PrefUtil::set_background_image(self)

    @scores = nil
  end

  def game=(game)
    @game = game
    @game.add_listener(self) if game
    @model = Gtk::ListStore.new(String, String)
    @list.set_model(@model)
  end

  def game_updated(hand_results)
    row = @model.append()
    # TODO: Make output look nicer
    @model.set_value(row, 0, hand_results.inspect)
    @model.set_value(row, 1, (hand_results.type == GameModel::Type::POSITIVE) ? "green" :
                             (hand_results.type == GameModel::Type::MIZERE) ? "blue" : "yellow")
  end
end
