#! /usr/bin/env ruby

#
# $Id$
#
# Main startup module for Hildon
#

require 'hildon'
require 'gtk2'
require 'model/pref_calc_model'
require 'model/pref_calc_scores'

require 'pref_calc_actions'
require 'pref_calc_view'
require 'pref_calc_menu'
require 'pref_history_view'
require 'pref_totals_view'
require 'pref_toolbar'
require 'pref_util'

GLib.application_name = "Preferans Calculator"

class MainWindow < Hildon::Window
  include GetText

  VIEW_TABLE = 0
  VIEW_TOTALS = 1
  VIEW_HISTORY = 2

  attr_accessor :notebook, :table_widget, :totals_widget
  attr_reader :game, :scores

  def initialize
    super()

    set_title("Prefcalc")

    signal_connect('delete_event') { Gtk.main_quit }

    @notebook=Gtk::Notebook.new
    @table_widget = PrefCalcView.new
    @totals_widget = PrefTotalsView.new
    @history_widget = PrefHistoryView.new

    main_menu = PrefCalcMenu.new
    set_menu main_menu

    hbox=Gtk::HBox.new
    hbox.homogeneous = false

    @notebook.append_page(@table_widget, Gtk::Label.new("Game"))
    @notebook.append_page(@totals_widget, Gtk::Label.new("Totals"))
    @notebook.append_page(@history_widget, Gtk::Label.new("History"))
    @notebook.show_border = false
    @notebook.show_tabs = false
    hbox.pack_start(PrefToolbar.new, false, false, 0)
    hbox.pack_start(@notebook, true, true, 0)

    add hbox

    @game = nil

    @is_fullscreen = false
    signal_connect('key-press-event') {|w,e| key_press_event(w,e)}

  end

  def game=(game)
    @game = game
    @scores = GameScores.new(@game)
    @table_widget.scores = @scores
    @totals_widget.scores = @scores
    @history_widget.game = game
  end

  def select_round_by_index(idx)
    @table_widget.select_round_by_index(idx)
  end

  def fullscreen?
    return @is_fullscreen
  end

  def fullscreen
    super
    @table_widget.clear
    @is_fullscreen = true
  end

  def unfullscreen
    super
    @table_widget.clear
    @is_fullscreen = false
  end

  def key_press_event(widget, event)
    case event.keyval
    when Gdk::Keyval::GDK_F6
      fullscreen? ? unfullscreen : fullscreen
    end
  end

end

program = Hildon::Program.new
$main_app_window  = MainWindow.new
$action_page_game.do

program.add_window $main_app_window

$main_app_window.show_all
$main_app_window.resizable=false

Gtk.main

