#
# $Id$
#
# Main menu
#

require 'gtk2'
require 'model/pref_calc_model'
require 'pref_calc_view'
require 'pref_calc_actions'
require 'new_game_dialog'
require 'hand_results_dialog'

$APP_NAME = "PrefCalc"
$APP_VERSION = "0.4"
$GPL_TEXT = "#{$APP_NAME} is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.\n\n" +
    "#{$APP_NAME} is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.\n\n" +
    "You should have received a copy of the GNU General Public License along with #{$APP_NAME}. If not, see <http://www.gnu.org/licenses/>."

class PrefCalcMenu < Gtk::Menu

  def initialize()
    super()

    m_file = Gtk::Menu.new
    mi_file = Gtk::MenuItem.new '_File'
    add mi_file
    mi_file.submenu = m_file

    @mi_file_new = Gtk::MenuItem.new '_New'
    @mi_game_round = Gtk::MenuItem.new 'Another _round...'
    @mi_help_about = Gtk::MenuItem.new '_About'
    @mi_close = Gtk::MenuItem.new '_Close'
    @mi_view_game = Gtk::RadioMenuItem.new '_Game'
    @mi_view_totals = Gtk::RadioMenuItem.new '_Totals'

    #
    # File submenu
    #
    @mi_file_new.signal_connect('activate') { $action_game_new.do }
    $action_game_new.add_listener(@mi_file_new)
    m_file.add @mi_file_new


    #
    # Game submenu
    #
    m_game = Gtk::Menu.new
    mi_view_game = Gtk::MenuItem.new '_Game'
    add mi_view_game
    mi_view_game.submenu = m_game

    @mi_game_round.signal_connect('activate') { $action_round_new.do }
    $action_round_new.add_listener(@mi_game_round)
    m_game.add @mi_game_round
 
    #
    # Help submenu
    #
    m_help = Gtk::Menu.new
    mi_help = Gtk::MenuItem.new '_Help'
    add mi_help
    mi_help.submenu = m_help

    @mi_help_about.signal_connect('activate') { $action_about.do }
    $action_about.add_listener(@mi_help_about)

    m_help.add @mi_help_about

    @mi_close.signal_connect('activate') { $action_quit.do }
    $action_quit.add_listener(@mi_close)

    add @mi_close
  end
end
