#
# $Id$
#
# GUI Actions
#

require 'gtk2'
require 'new_game_dialog'
require 'hand_results_dialog'
require 'model/pref_calc_model_variants'

class PrefCalcAction
  include GetText

  def initialize
    @listeners = Array.new
  end

  def add_listener(listener)
    @listeners.push(listener)
  end

  def do
    raise 'Undefined action'
  end

  def sensitive=(is_sensitive)
    @listeners.each{ |l| l.sensitive = is_sensitive }
  end

  def add_button(btn)
    btn.signal_connect('clicked') { self.do }
    add_listener(btn);
  end
end 

$action_game_new = PrefCalcAction.new
$action_round_new = PrefCalcAction.new
$action_about = PrefCalcAction.new
$action_quit = PrefCalcAction.new

$action_page_game = PrefCalcAction.new
$action_page_totals = PrefCalcAction.new
$action_page_history = PrefCalcAction.new

def $action_game_new.do
  dialog = NewGameDialog.new
  dialog.widget.run do |response|
    case response
      when Gtk::Dialog::RESPONSE_OK
        case dialog.game_variant
          when NewGameDialog::LENINGRAD
            variant=Leningrad.new
          when NewGameDialog::ROSTOV
            variant=Rostov.new
          when NewGameDialog::SOCHI
            variant=Sochi.new
        end
        $main_app_window.game = Game.new(variant, dialog.player_names, dialog.whist_price)
        $action_round_new.sensitive = true
    end
    dialog.widget.destroy
  end
end

def $action_round_new.do
  dialog = HandResultsDialog.new($main_app_window.game)
  dialog.widget.run
  if ! dialog.results.nil?
    $main_app_window.game.append(dialog.results)
  end
end
 
def $action_about.do
  about_box = Gtk::AboutDialog.new()
  about_box.name = $APP_NAME
  about_box.version = $APP_VERSION
  about_box.copyright = "Copyright \xc2\xa9 2007-2009 Sergey V. Udaltsov"
  about_box.authors = [ "Sergey V. Udaltsov <svu@gnome.org>" ]
  about_box.license = $GPL_TEXT
  about_box.wrap_license = true
  about_box.website = 'http://prefcalc.garage.maemo.org'
  about_box.translator_credits = _('TRANSLATOR')
  about_box.modal = true
  about_box.transient_for = $main_app_window
  about_box.signal_connect('response') { about_box.destroy }

  about_box.show
end

def $action_quit.do
  Gtk.main_quit
end

def $action_page_game.do
  $main_app_window.notebook.page = 0
  $action_page_game.sensitive = false
  $action_page_totals.sensitive = true
  $action_page_history.sensitive = true
end

def $action_page_totals.do
  $main_app_window.notebook.page = 1
  $action_page_game.sensitive = true
  $action_page_totals.sensitive = false
  $action_page_history.sensitive = true
end

def $action_page_history.do
  $main_app_window.notebook.page = 2
  $action_page_game.sensitive = true
  $action_page_totals.sensitive = true
  $action_page_history.sensitive = false
end

