#!/usr/bin/env ruby

#
# $Id$
#

require 'pref_util'
require 'gconf2'
require 'model/pref_calc_model'

#
# Popup input dialog
# asking for a player name
#
class AnotherPlayer
  include GetText

  DIALOG_NAME = "another_player"

  def initialize
    @glade = PrefUtil::load_glade(DIALOG_NAME, self)
  end

  def widget
    @glade[DIALOG_NAME]
  end

  def player_name
    @glade["txt_player_name"].text
  end

end

#
# The dialog gathering the data for the game start
#
class NewGameDialog
  include GetText

  DIALOG_NAME = "new_game"
  TEXT_COLUMN = 0

  LENINGRAD = 0
  ROSTOV = 1
  SOCHI = 2

  GCONF_KEY_PLAYERS="/apps/prefcalc/players"

  def initialize
    @glade = PrefUtil::load_glade(DIALOG_NAME, self)

    @client=GConf::Client.default

    @model = Gtk::ListStore.new(String)
    @players_list = @glade['list_players']
    @players_list.set_model(@model)

    # restore old players
    old_players=@client.get(GCONF_KEY_PLAYERS)
    if old_players
      old_players.each do |player_name|
        iter = @model.append()
        iter.set_value(TEXT_COLUMN, player_name);
      end
    end

    # save players on exit
    @glade[DIALOG_NAME].signal_connect('response') { |dlg, response_id| 
      if response_id == Gtk::Dialog::RESPONSE_OK
        @client[GCONF_KEY_PLAYERS]=player_names
      end
    }

    @players_list.append_column(Gtk::TreeViewColumn.new("Name", Gtk::CellRendererText.new, 
                                 :text => TEXT_COLUMN))
    @players_list.headers_visible = false
    enable_disable_buttons

    @players_list.selection.signal_connect("changed") { 
      enable_disable_buttons
    }

    # Populate game variants
    @game_variants = @glade['cmb_convention']
    gv_model = Gtk::ListStore.new(String)
    [_('Leningrad'), _('Rostov'), _('Sochi')].each{ |variant|
      iter = gv_model.append()
      iter.set_value(TEXT_COLUMN, variant);
    }
    @game_variants.set_model(gv_model);
    @game_variants.active = 0;
  end

  def widget
    @glade[DIALOG_NAME]
  end

  def enable_disable_buttons
    pcount = 0
    @model.each {|m,p,i| pcount = pcount+1 }

    @glade['btn_game_ok'].sensitive = (pcount == 3 || pcount == 4)

    @glade['btn_add'].sensitive = (pcount < 4)
    @glade['btn_del'].sensitive = !(@players_list.selection.selected.nil?)
  end
 
  def on_btn_add_clicked(widget)     
    dialog = AnotherPlayer.new
    dialog.widget.run do |response|
      case response
        when Gtk::Dialog::RESPONSE_OK
          player_name = dialog.player_name
          if  player_name != ''
            if (player_names.index(player_name).nil?)
              iter = @model.append()
              iter.set_value(TEXT_COLUMN, player_name);
              enable_disable_buttons
            else
              infoDlg = Gtk::MessageDialog.new(dialog.widget, 
                                Gtk::Dialog::DESTROY_WITH_PARENT,
                                Gtk::MessageDialog::INFO,
                                Gtk::MessageDialog::BUTTONS_CLOSE,
                                "Player #{player_name} already exists")
              infoDlg.run
              infoDlg.destroy
            end
          end
      end
      dialog.widget.destroy
    end

  end

  def on_btn_del_clicked(widget)
    @model.remove(@players_list.selection.selected)
    enable_disable_buttons
  end

  def player_names
    rv = Array.new
    @model.each{|m, p, i| rv.push(i[TEXT_COLUMN]) }
    return rv
  end

  def game_variant
    @game_variants.active
  end

  def whist_price
    @glade['sp_whistprice'].text.to_i
  end
end

# Main program
if __FILE__ == $0
  dlg = NewGameDialog.new
  dlg.widget.show_all 
  Gtk.main
end
