#!/usr/bin/env ruby

#
# $Id$
#
# Pref game model vairnats: Leningrad, Sochi, Rostov
#

require 'model/pref_calc_model'

#
# Leningrad's variant
#
class Leningrad < GameVariant
  def trick_price_as_whist
    4
  end

  def base_game_price
    2
  end

  def base_untaken_trick_price_on_game
    4
  end

  def base_untaken_trick_price_on_whist
    2
  end

  def taken_trick_price_on_pass_out(game)
    # 6->2, 7->4, 8->6
    (game.pass_out_counter - 5) * 2
  end

  def reset_pass_out(game)
    game.pass_out_counter = 6
  end

  def another_pass_out(game)
    # pass outs are 6, 7, 8, 8, 8, 8...
    if (game.pass_out_counter < 8)
      game.pass_out_counter = game.pass_out_counter + 1;
    end
  end

  def is_whist_gentlemanish
    true
  end
end


#
# Rostov's or Moscow's variant
#
class Rostov < GameVariant
  def trick_price_as_whist
    2
  end

  def base_game_price
    2
  end

  def base_untaken_trick_price_on_game
    2
  end

  def base_untaken_trick_price_on_whist
    1
  end

  def taken_trick_price_on_pass_out(game)
    # TODO: pass-out goes into whists
    0
  end

  def reset_pass_out(game)
    #stateless pass-out
  end

  def another_pass_out(game)
    #stateless pass-out
  end

  def is_whist_gentlemanish
    true
  end
end


#
# Sochi's variant
#
class Sochi < GameVariant
  def trick_price_as_whist
    2
  end

  def base_game_price
    2
  end

  def base_untaken_trick_price_on_game
    2
  end

  def base_untaken_trick_price_on_whist
    2
  end

  def taken_trick_price_on_pass_out(game)
    # 6->1, 7->2, 8->3
    game.pass_out_counter - 5
  end

  def reset_pass_out(game)
    game.pass_out_counter = 6
  end

  def another_pass_out(game)
    # pass outs are 6, 7, 8, 8, 8, 8...
    if (game.pass_out_counter < 8)
      game.pass_out_counter = game.pass_out_counter + 1;
    end
  end

  def is_whist_gentlemanish
    false
  end
end


