#
# $Id$
#
# Drawing helper class
#

require 'gtk2'
require 'cairo'

class Canvas < Gtk::DrawingArea
  def initialize
    super
    signal_connect("expose_event") { |w,e| expose_event(w,e) }
    signal_connect("configure_event") { |w, e| configure_event(w,e) }
    @buffer = nil
    @bgc = nil
  end

  def expose_event(w,e)
    unless @buffer.nil?
      rec = e.area
      cr = w.window.create_cairo_context
      cr.set_source(@buffer, 0, 0)
      cr.paint
    end

    false
  end

  def clear(b = @buffer)
    return if b.nil?

    w = b.width
    h = b.height
    @bgc = self.style.bg(self.state) if @bgc.nil?
    if (w > 0 && h > 0)
      cr = Cairo::Context.new(b)
      cr.move_to(0, 0)
      cr.line_to(0, h)
      cr.line_to(w, h)
      cr.line_to(w, 0)
      cr.close_path
      cr.set_source_rgb(@bgc.red/65536.0, @bgc.green/65536.0, @bgc.blue/65536.0)
      cr.fill
    end
  end

  def configure_event(w,e)
    g = w.window.geometry
    if (g[2] > 0 && g[3] > 0)
      b = Cairo::ImageSurface.new(Cairo::FORMAT_ARGB32, g[2], g[3])
      clear(b)
      @buffer = b
    end
    true
  end
end
