// -*- coding: utf-8; -*-
// (c) Copyright 2010, Nick Slobodsky (Николай Слободской)
// This file is part of PlansPlant.
//
// PlansPlant is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// PlansPlant is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with PlansPlant.  If not, see <http://www.gnu.org/licenses/>.
//
#ifndef PLANS_PLANT_WIDGETS_HPP
#define PLANS_PLANT_WIDGETS_HPP
#include <QDialog>
#include <QMainWindow>
#include "tree_widgets.hpp"
#include "ui_task.h" //! \todo Move to cpp.
#include "ui_blockers_editor.h"
namespace PlansPlant
{
#ifdef Q_WS_MAEMO_5
  void disable_kinetic_scroller( QAbstractScrollArea* Widget );
#endif // Q_WS_MAEMO_5

  class PLANSPLANT_CLASS TimeSpanSpinBox : public QSpinBox
  {
  public:
    TimeSpanSpinBox( QWidget* Parent );
  protected:
    QString textFromValue( int Value ) const;
    int valueFromText( const QString& Text ) const;
    QValidator::State validate( QString& Text, int& Pos ) const;
  }; // TimeSpanSpinBox
  class BlockersListModel;
  class PLANSPLANT_CLASS BlockersEditor : public QWidget
  {
    Q_OBJECT
  public:
    BlockersEditor( TasksModel& Model0, Task* Object0 = 0, QWidget* Parent = 0 );
    const Task::List& blockers() const;
    QModelIndex selected_blocker() const;
    void supertask( Task* NewSuperTask );
  public slots:
    void add_blocker();
    void remove_blocker();
    void move_blocker_up();
    void move_blocker_down();
    bool can_add_blocker( Task& NewBlocker );
    void blockers_pool_switched( bool On );
    void blockers_pool_selection_changed( const QItemSelection& New );
    void blockers_pool_selection_changed( const QModelIndex& NewIndex );
    void blockers_list_selection_changed( const QItemSelection& New );
    void blockers_list_selection_changed( const QModelIndex& NewIndex );
  signals:
    void blockers_changed();
  protected:
    TasksModel& Model;
    BlockersListModel* Blockers;
    Task* Object;
    Task* SuperTask; // To check for loops, it can differ from the Object's supertask if the widget is in the TaskDialog.
    Ui::BlockersEditor UI;
  }; // BlockersEditor
  class PLANSPLANT_CLASS BlockersEditorDialog : public QDialog
  {
    Q_OBJECT
  protected:
    class EditorWidget : public BlockersEditor
    {
    public:
      EditorWidget( TasksModel& Model0, Task* Object0 = 0, QDialog* Parent = 0 );
      bool accept();
    }; // EditorWidget
  public:
    BlockersEditorDialog( TasksModel& Model0, Task* Object0 = 0, QWidget* Parent = 0 );
    QSize sizeHint() const;
    void accept();
  protected:
    EditorWidget Editor;
  }; // BlockersEditorDialog

  class PLANSPLANT_CLASS TaskDialog : public QDialog
  { //! \todo Make special widgets for plan start & finish.
    Q_OBJECT
    class PLANSPLANT_CLASS TimeActions
    {
    public:
      enum Action { Now, StartOfDay, EndOfDay, Estimated, FromSubItems, FromSubtasks, BlockersStart, BlockersFinish, FromSupertask, ActionsCount };
      TimeActions();
      Action default_action() const { return Default; }
      void default_action( Action NewDefault );
      QAction* action( Action Act ) const { return Actions[ Act ]; }
      QAction* now() const { return Actions[ Now ]; }
      QAction* start_of_day() const { return Actions[ StartOfDay ]; }
      QAction* end_of_day() const { return Actions[ EndOfDay ]; }
      void create( QToolButton* NewButton );
    protected:
      QToolButton* Button;
      Action Default;
      QAction* Actions[ ActionsCount ];
    }; // TimeActions
  public:
    TaskDialog( TasksModel& Model0, Task* Object0 = 0, QWidget* Parent = 0 );
    Task::TimeUnits time_units();
    void accept();
    void supertask( Task* NewSuperTask );
  public slots:
    void select_supertask();
    void supertask_toggled( bool On );
    void supertask_changed();
    void blockers_changed();
    void plan_start_now();
    void plan_start_start_of_day();
    void plan_start_end_of_day();
    void plan_start_estimated();
    void plan_start_from_subitems();
    void plan_start_from_subtasks();
    void plan_start_blockers_start();
    void plan_start_blockers_finish();
    void plan_start_from_supertask();
    void plan_finish_now();
    void plan_finish_start_of_day();
    void plan_finish_end_of_day();
    void plan_finish_estimated();
    void plan_finish_from_subitems();
    void plan_finish_from_subtasks();
    void plan_finish_blockers_start();
    void plan_finish_blockers_finish();
    void plan_finish_from_supertask();
  protected:
    void check_time( Task* Tsk, bool Start, QDateTime& Result );
    QDateTime subitems_time( bool UseBlockers, bool UseSubtasks, bool Start );
    TasksModel& Model;
    Task* Object;
    Task* SuperTask;
    BlockersEditor* Blockers;
    Ui::TaskDialog UI;
    TimeActions PlanStartActions;
    TimeActions PlanFinishActions;
  }; // TaskDialog
  class PLANSPLANT_CLASS TaskSelectDialog : public QDialog
  {
    Q_OBJECT
  public:
    TaskSelectDialog( TasksModel& Model0, QWidget* Parent = 0, Task* CurrentTask0 = 0, const QString& Title = tr( "Select Task" ) );
    void accept();
    Task* current_task() const { return CurrentTask; }
  protected slots:
    virtual void selection_changed( const QItemSelection& New );
    virtual void selection_changed( const QModelIndex& NewIndex );
  protected:
    Task* CurrentTask;
    TasksTreeWidget* TasksTree;
    QDialogButtonBox* Buttons;
  }; // TaskSelectDialog
  class PLANSPLANT_CLASS ParentSelectDialog : public TaskSelectDialog
  {
    Q_OBJECT
  public:
    ParentSelectDialog( TasksModel& Model0, QWidget* Parent = 0, const Task::List& Blockers0 = Task::List(), Task* ForTask0 = 0, Task* SuperTask0 = 0 );
  protected slots:
    void selection_changed( const QModelIndex& New );
  protected:
    Task* ForTask;
    const Task::List& Blockers;
  }; // ParentSelectDialog
  class PLANSPLANT_CLASS BlockerSelectDialog : public TaskSelectDialog
  {
    Q_OBJECT
  public:
    BlockerSelectDialog( TasksModel& Model0, QWidget* Parent = 0, Task* ForTask0 = 0, Task* Blocker0 = 0 );
  protected slots:
    void selection_changed( const QModelIndex& New );
  protected:
    Task* ForTask;
  }; // BlockerSelectDialog

  class TaskItemFinder;
  class PLANSPLANT_CLASS MainWindow : public QMainWindow, public Task::Watcher
  {
    Q_OBJECT
  public:
    static QString basename( const QString& FileName );
    static void recent_file( const QString& FileName );
    static bool desktop_view() { return DesktopView; } //!< Is this application's window open on the desktop (through X-forwarding)?
    static void desktop_view( bool DV ) { DesktopView = DV; }
    MainWindow( QWidget* Parent = 0, Qt::WindowFlags Flags = 0 );
    ~MainWindow();
    void create_menu();
    QSize sizeHint() const;
  public slots:
    bool close_file( bool Force = false );
    bool open_file( const QString& FileName, bool AddToRecent = true );
    bool open_file();
    bool save_file();
    bool save_file_as();
    bool export_to_html();
    bool new_file();
    void about();
    void show_tasks_tree();
    void show_time_list();
    void start_stop();
    void update_buttons();
    void search();
    void search_next();
    void move_times();
  protected:
    void task_changed( Task& Object, Task::Change::FieldID Field );
    void connect_actions();
    void closeEvent( QCloseEvent* Close );
    static bool DesktopView; // This will be changed soon.
    TasksFile* Tasks;
    TasksTreeWidget* Tree;
    TasksTimeListWidget* TimeList;
    QAction* TreeMenuAction;
    QAction* TimeListMenuAction;
    QAction* StartStopAction;
    QToolBar* TreeTools;
    QToolBar* TimeListTools;
    TaskItemFinder* Finder;
  }; // MainWindow
} // PlansPlant
#endif // PLANS_PLANT_WIDGETS_HPP
