#ifndef PLANSPLANT_TASKS_CHANGES_HPP
#define PLANSPLANT_TASKS_CHANGES_HPP
#include <plansplant/tasks.hpp>
#include <QVariant>
namespace PlansPlant
{
  class Task::Changes
  {
  protected:
    class StringChange : public Change
    {
    protected:
      StringChange( const QString& Value0 = QString(), FieldID Field0 = None ) : Change( Field0 ), Value( Value0 ) {}
      virtual void load_fields( QXmlStreamReader& Stream );
      void write_fields( QXmlStreamWriter& Stream ) const { Stream.writeTextElement( "value", Value ); }
      QString Value;
    }; // StringChange
    template<typename DataType> class DataChange : public Change
    {
    protected:
      DataChange( DataType Value0 = 0, FieldID Field0 = None ) : Change( Field0 ), Value( Value0 ) {}
      void write_fields( QXmlStreamWriter& Stream ) const { Stream.writeTextElement( "value", QString::number( Value ) ); }
      DataType Value;
    }; // DataChange
    class DateTimeChange : public Change
    {
    protected:
      DateTimeChange( const QDateTime& Value0 = QDateTime(), FieldID Field0 = None ) : Change( Field0 ), Value( Value0 ) {}
      virtual void load_fields( QXmlStreamReader& Stream );
      void write_fields( QXmlStreamWriter& Stream ) const { if( Value.isValid() ) Stream.writeTextElement( "value", Value.toUTC().toString( "yyyy-MM-dd hh:mm:ss" ) ); }
      QDateTime Value;
    }; // DateTimeChange
  public:
    //! \todo Combine the time and tasks lists' change events because they are almost similar.
    class Times : public Change
    {
      class Operation
      {
      public:
	typedef Operation* Pointer;
	typedef QVector<Pointer> List;
	enum Type { None, Insert, Remove, Change, Move };
      protected:
	Operation( int Index0 = -1 ) : Index( Index0 ) {}
      public:
	virtual ~Operation() {}
	virtual Type type() const { return None; }
	int index() const { return Index; }
	virtual void apply( Task& Object ) const = 0;
	virtual void write( QXmlStreamWriter& Stream ) const;
	virtual void load_fields( QXmlStreamReader& Stream );
      protected:
	virtual void load_field( const QStringRef& Tag, QXmlStreamReader& Stream );
	virtual void write_fields( QXmlStreamWriter& Stream ) const;
	int Index;
      }; // Operation
    public:
      class Operations
      {
      public:
	class Insert : public Operation
	{
	public:
	  Insert( int Index0 = -1 ) : Operation( Index0 ) {}
	  Insert( const Task::TimeSlice& Slice0, int Index0 = -1 ) : Operation( Index0 ), Slice( Slice0 ) {}
	  Type type() const { return Operation::Insert; }
	  void apply( Task& Object ) const;
	protected:
	  void load_field( const QStringRef& Tag, QXmlStreamReader& Stream );
	  void write_fields( QXmlStreamWriter& Stream ) const;
	  Task::TimeSlice Slice;
	}; // Insert
	class Remove : public Operation
	{
	public:
	  Remove( int Index0 = -1 ) : Operation( Index0 ) {}
	  Type type() const { return Operation::Remove; }
	  void apply( Task& Object ) const;
	}; // Remove
	class Move : public Operation
	{
	public:
	  Move( int Index0 = -1, int NewIndex0 = -1 ) : Operation( Index0 ), NewIndex( NewIndex0 ) {}
	  Type type() const { return Operation::Move; }
	  void apply( Task& Object ) const;
	protected:
	  void load_field( const QStringRef& Tag, QXmlStreamReader& Stream );
	  void write_fields( QXmlStreamWriter& Stream ) const;
	  int NewIndex;
	}; // Move
	class Change : public Operation
	{
	public:
	  enum FieldID{ None, Start, Finish };
	  Change( int Index0 = -1 ) : Operation( Index0 ), Field( None ) {}
	  Change( const QDateTime& NewTime0, FieldID Field0 = Finish, int Index0 = -1 ) : Operation( Index0 ), Field( Field0 ), NewTime( NewTime0 ) {}
	  Type type() const { return Operation::Change; }
	  void apply( Task& Object ) const;
	protected:
	  void load_field( const QStringRef& Tag, QXmlStreamReader& Stream );
	  void write_fields( QXmlStreamWriter& Stream ) const;
	  FieldID Field;
	  QDateTime NewTime;
	}; // Change
      }; // Operations
      static Times* load( QXmlStreamReader& Stream, TasksFile& Tasks );
      Times( Operation* FirstOperation = 0 );
    protected:
      ~Times();
      void apply( Task& Object, TasksFile& File ) const;
      Operation* load_operation( Operation::Type OpCode, QXmlStreamReader& Stream );
      void load_fields( QXmlStreamReader& Stream );
      void write_fields( QXmlStreamWriter& Stream ) const;
      Operation::List Actions;
    }; // Times
    class TasksListChange : public Change
    {
    protected:
      class Operation
      {
      public:
	typedef Operation* Pointer;
	typedef QList<Pointer> List;
	enum Type { None, Replace, Add, Remove, Move };
      protected:
	Operation( Type OpCode0 = None ) : OpCode( OpCode0 ) {}
	Operation( Task& Object, Type OpCode0 = None ) : OpCode( OpCode0 ) { Tasks.push_back( &Object ); }
	Operation( const Task::List& Objects, Type OpCode0 = None ) : Tasks( Objects ), OpCode( OpCode0 ) {}
      public:
	virtual ~Operation() {}
	virtual void apply( Task& Target ) const = 0;
	virtual void inform( Task::Watcher& Target, Task& Object ) const = 0;
	virtual void write( QXmlStreamWriter& Stream ) const;
	Type type() const { return OpCode; }
	virtual void load_fields( QXmlStreamReader& Stream, TasksFile& Tasks );
      protected:
	virtual void load_field( const QStringRef& Tag, QXmlStreamReader& Stream, TasksFile& Tasks );
	virtual void write_fields( QXmlStreamWriter& Stream ) const;
	Task::List Tasks;
	Type OpCode;
	//! \todo add undo
      }; // Operation
    public:
      class Operations;
      TasksListChange( FieldID Field0 = None ) : Change( Field0 ) {}
      TasksListChange( Operation& FirstOp, FieldID Field0 = None ) : Change( Field0 ) { Actions.push_back( &FirstOp ); }
    protected:
      ~TasksListChange();
      void apply( Task& Object, TasksFile& File ) const;
      void inform( Task::Watcher& Target, Task& Object ) const;
      virtual void load_fields( QXmlStreamReader& Stream, TasksFile& Tasks );
      virtual Operation* load_operation( Operation::Type OpCode, QXmlStreamReader& Stream, TasksFile& Tasks );
      void write_fields( QXmlStreamWriter& Stream ) const;
      Operation::List Actions;
    }; // TasksListChange
    class TasksListChange::Operations
    {
    public:
      class Move : public Operation
      {
      protected:
	Move( Task& ToMove0, int From0, int To0 );
	Move() : Operation( Operation::Move ) {}
	void load_field( const QStringRef& Tag, QXmlStreamReader& Stream, TasksFile& Tasks );
	void write_fields( QXmlStreamWriter& Stream ) const;
	int From;
	int To;
      }; // Move
    }; // Operations
    class Name : public StringChange
    {
    public:
      static Name* load( QXmlStreamReader& Stream, TasksFile& Tasks );
      Name( const QString& TaskName0 = QString() ) : StringChange( TaskName0, Task::Change::Name ) {} 
      void apply( Task& Object, TasksFile& /*File*/ ) const { Object.name( Value ); }
    }; // Name
    class Description : public StringChange
    {
    public:
      static Description* load( QXmlStreamReader& Stream, TasksFile& Tasks );
      Description( const QString& TaskDescription0 = QString() ) : StringChange( TaskDescription0, Task::Change::Description ) {}
      void apply( Task& Object, TasksFile& /*File*/ ) const { Object.description( Value ); }
    }; // Description
    class Priority : public DataChange<int>
    {
    public:
      static Priority* load( QXmlStreamReader& Stream, TasksFile& Tasks );
      Priority( int Value0 = 0 ) : DataChange<int>( Value0, Task::Change::Priority ) {}
      void apply( Task& Object, TasksFile& /*File*/ ) const { Object.priority( Value ); }
    }; // Priority
    class Completed : public DataChange<double>
    {
    public:
      static Completed* load( QXmlStreamReader& Stream, TasksFile& Tasks );
      Completed( double Value0 = 0 ) : DataChange<double>( Value0, Task::Change::Completed ) {}
      void apply( Task& Object, TasksFile& /*File*/ ) const { Object.completed( Value ); }
    }; // Completed
    class PlanStart : public DateTimeChange
    {
    public:
      static PlanStart* load( QXmlStreamReader& Stream, TasksFile& Tasks );
      PlanStart( const QDateTime& Value0 = QDateTime() ) : DateTimeChange( Value0, Task::Change::PlanStart ) {}
      void apply( Task& Object, TasksFile& /*File*/ ) const { Object.plan_start( Value ); }
    }; // PlanStart
    class PlanFinish : public DateTimeChange
    {
    public:
      static PlanFinish* load( QXmlStreamReader& Stream, TasksFile& Tasks );
      PlanFinish( const QDateTime& Value0 = QDateTime() ) : DateTimeChange( Value0, Task::Change::PlanFinish ) {}
      void apply( Task& Object, TasksFile& /*File*/ ) const { Object.plan_finish( Value ); }
    }; // PlanFinish
    class Estimation : public DataChange<Time>
    {
    public:
      static Estimation* load( QXmlStreamReader& Stream, TasksFile& Tasks );
      Estimation( Time Value0 = 0 ) : DataChange<Time>( Value0, Task::Change::Estimation ) {}
      void apply( Task& Object, TasksFile& /*File*/ ) const { Object.estimation( Value ); }
    }; // Estimation
    class EstimationUnits : public DataChange<TimeUnits>
    {
    public:
      static EstimationUnits* load( QXmlStreamReader& Stream, TasksFile& Tasks );
      EstimationUnits( TimeUnits Value0 = Seconds ) : DataChange<TimeUnits>( Value0, Task::Change::EstimationUnits ) {}
      void apply( Task& Object, TasksFile& /*File*/ ) const { Object.estimation_units( Value ); }
    }; // EstimationUnits
    class Comment : public StringChange
    {
    public:
      static Comment* load( QXmlStreamReader& Stream, TasksFile& Tasks );
      Comment( const QString& TaskComment0 = QString() ) : StringChange( TaskComment0, Task::Change::Comment ) {}
      void apply( Task& Object, TasksFile& /*File*/ ) const { Object.comment( Value ); }
    }; // Comment
    class SuperTask : public Change
    {
    public:
      static SuperTask* load( QXmlStreamReader& Stream, TasksFile& Tasks );
      SuperTask( Task* NewSuperTask0 = 0 ) : Change( Task::Change::SuperTask ), Value( NewSuperTask0 ) {}
      void apply( Task& Object, TasksFile& File ) const;
      void write_fields( QXmlStreamWriter& Stream ) const;
    protected:
      Task* Value;
    }; // SuperTask
    class Blockers : public TasksListChange
    {
    public:
      class Operations
      {
      public:
	class Add : public Operation
	{
	public:
	  Add( Task& ToAdd0 );
	  Add() : Operation( Operation::Add ) {}
	protected:
	  void apply( Task& Target ) const;
	  void inform( Task::Watcher& Target, Task& Object ) const;
	}; // Add
	class Remove : public Operation
	{
	public:
	  Remove( Task& ToRemove0 );
	  Remove() : Operation( Operation::Remove ) {}
	protected:
	  void apply( Task& Target ) const;
	  void inform( Task::Watcher& Target, Task& Object ) const;
	}; // Remove
	class Replace : public Operation
	{
	public:
	  Replace( const Task::List& ToReplace0 );
	  Replace() : Operation( Operation::Replace ) {}
	protected:
	  void apply( Task& Target ) const;
	  void inform( Task::Watcher& Target, Task& Object ) const;
	}; // Replace
	class Move : public TasksListChange::Operations::Move
	{
	public:
	  Move( Task& ToMove0, int From0, int To0 );
	  Move() {}
	protected:
	  void apply( Task& Target ) const;
	  void inform( Task::Watcher& Target, Task& Object ) const;
	}; // Move
      }; // Operations
      static Blockers* load( QXmlStreamReader& Stream, TasksFile& Tasks );
      Blockers( const Task::List& NewBlockers0 ) : TasksListChange( *new Operations::Replace( NewBlockers0 ), Task::Change::Blockers ) {}
      Blockers( Operation& FirstOp ) : TasksListChange( FirstOp, Task::Change::Blockers ) {}
    protected:
      Blockers() : TasksListChange( Task::Change::Blockers ) {}
      Operation* load_operation( Operation::Type OpCode, QXmlStreamReader& Stream, TasksFile& Tasks );
    }; // Blockers
    class SubTasks : public TasksListChange
    {
    public:
      class Move : public Operations::Move
      {
      public:
	Move( Task& ToMove0, int From0, int To0 );
	Move() {}
      protected:
	void apply( Task& Target ) const;
	void inform( Task::Watcher& Target, Task& Object ) const;
      }; // Move
      static SubTasks* load( QXmlStreamReader& Stream, TasksFile& Tasks );
      SubTasks( Operation& FirstOp ) : TasksListChange( FirstOp, Task::Change::SubTasks ) {}
    protected:
      SubTasks() : TasksListChange( Task::Change::SubTasks ) {}
      Operation* load_operation( Operation::Type OpCode, QXmlStreamReader& Stream, TasksFile& Tasks );
    }; // SubTasks
  }; // Changes
} // PlansPlant
#endif // PLANSPLANT_TASKS_CHANGES_HPP
