// -*- coding: utf-8; -*-
// (c) Copyright 2010, Nick Slobodsky (Николай Слободской)
// This file is part of PlansPlant.
//
// PlansPlant is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// PlansPlant is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with PlansPlant.  If not, see <http://www.gnu.org/licenses/>.
//
#ifndef PLANS_PLANT_EVENTS_HPP
#define PLANS_PLANT_EVENTS_HPP
#include <plansplant/tasks.hpp>
namespace PlansPlant
{
  //! \todo Change tasks references to IDs where possible.
  class Task::Watcher::Events
  {
  public:
    class PLANSPLANT_CLASS TaskAdded : public Event
    {
    public:
      static TaskAdded* load( QXmlStreamReader& Stream, TasksFile& Tasks );
      TaskAdded( Task& Object0, ID Ident0 );
      Type type() const;
      void apply( TasksFile& Tasks ) const;
      void inform( Watcher& Dest ) const;
      void write_fields( QXmlStreamWriter& Stream ) const;
    protected:
      Task& Object;
    }; // TaskAdded
    class PLANSPLANT_CLASS TaskRemoved : public Event
    {
    public:
      static TaskRemoved* load( QXmlStreamReader& Stream, TasksFile& Tasks );
      TaskRemoved( Task& Object0, ID Ident0 );
      TaskRemoved( Task::ID ObjectID0, ID Ident0 );
      Type type() const;
      void apply( TasksFile& Tasks ) const;
      void inform( Watcher& Dest ) const;
      void write_fields( QXmlStreamWriter& Stream ) const;
    protected:
      Task::ID TaskID;
    }; // TaskRemoved
    class PLANSPLANT_CLASS TaskChanged : public Event
    {
    public:
      static TaskChanged* load( QXmlStreamReader& Stream, TasksFile& Tasks );
      TaskChanged( Task::ChangesList* Changes0, ID Ident0 );
      Type type() const;
      void apply( TasksFile& Tasks ) const;
      void inform( Watcher& Dest ) const;
      void write_fields( QXmlStreamWriter& Stream ) const;
    public:
      Task::ChangesList* Changes;
    }; // TaskChanged
    class PLANSPLANT_CLASS RootTaskMoved : public Event
    {
    public:
      static RootTaskMoved* load( QXmlStreamReader& Stream, TasksFile& Tasks );
      RootTaskMoved( Task& Object0, int From0, int To0, ID Ident0 );
      Type type() const;
      void apply( TasksFile& Tasks ) const;
      void inform( Watcher& Dest ) const;
      void write_fields( QXmlStreamWriter& Stream ) const;
      Task& Object;
      int From;
      int To;
    }; // RootTaskMoved
  }; // Events
} // PlansPlant
#endif // PLANS_PLANT_EVENTS_HPP
