// -*- coding: utf-8; -*-
// (c) Copyright 2010, Nick Slobodsky (Николай Слободской)
// This file is part of PlansPlant.
//
// PlansPlant is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// PlansPlant is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with PlansPlant.  If not, see <http://www.gnu.org/licenses/>.
//
#include <QApplication>
#include <QSettings>
#include <QTranslator>
#include <QLibraryInfo>
#include <QLocale>
#include <QDebug>
#include "plansplant/widgets.hpp"
#ifdef Q_WS_MAEMO_5
#include <QX11Info>
#include <X11/Xcursor/Xcursor.h>
#endif // Q_WS_MAEMO_5

int main( int argc, char* argv[] )
{
  QApplication App( argc, argv );
  QApplication::setOrganizationName( "Nick Slobodsky" );
  QApplication::setOrganizationDomain( "slobodsky.ru" );
  QApplication::setApplicationName( "PlansPlant" );
  QApplication::setApplicationVersion( "0.2.0-preview2" );
  QApplication::setAttribute( Qt::AA_DontShowIconsInMenus, false );
  QString Lang = QLocale().name();
  QTranslator QtTrans( &App );
  if( QtTrans.load( "qt_" + Lang, QLibraryInfo::location( QLibraryInfo::TranslationsPath ) ) ) App.installTranslator( &QtTrans );
  qDebug() << "Load translator. Locale:" << Lang;
  QTranslator Trans( &App ); //! \todo Make it really international and external (since we have installers for all platforms and don't have to distribute bare binaries).
  if( Trans.load( "libplansplant-" + Lang ) || ( QLocale().language() == QLocale::Russian && Trans.load( ":/lang/libplansplant-ru.qm" ) ) ) App.installTranslator( &Trans );

  QString FileName;
  //! \todo Use getopt and more options.
  bool NewFile = false;
  for( int I = 1; I < argc; I++ )
    if( !strcmp( argv[ I ], "--desktop-view" ) )
    {
      PlansPlant::MainWindow::desktop_view( true ); // This will be changed very soon!
#ifdef Q_WS_MAEMO_5
      XcursorSetTheme( QX11Info::display(), "DMZ-White" );
#endif // Q_WS_MAEMO_5
    }
    else if( !strcmp( argv[ I ], "--new-file" ) )
      NewFile = true;
    else
      FileName = QString::fromLocal8Bit( argv[ 1 ] );
  if( !NewFile && FileName.isEmpty() )
    FileName = QSettings().value( "Status/RecentFile" ).toString();
  PlansPlant::MainWindow* W = new PlansPlant::MainWindow();
  if( FileName.isEmpty() || !W->open_file( FileName, false ) )
    W->new_file();
  W->show();
  return App.exec();
} // main( int, char*[] )
