//  Pingus - A free Lemmings clone
//  Copyright (C) 1999 Ingo Ruhnke <grumbel@gmx.de>
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//  
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.

#ifndef HEADER_PINGUS_WORLDOBJS_LIQUID_HPP
#define HEADER_PINGUS_WORLDOBJS_LIQUID_HPP

#include "../res_descriptor.hpp"
#include "../worldobj.hpp"

namespace WorldObjsData {
class LiquidData;
}

namespace WorldObjs {

class Liquid : public WorldObj
{
private:
  Sprite sur;

  Vector3f pos;

  /** Cause to interpret the width in pixels instead of tiles */
  bool old_width_handling;

  int width;

  /** Number of miliseconds between frames */
  int speed;

public:
  Liquid(const FileReader& reader);

  float get_z_pos () const;
  void  on_startup();
  void  draw      (SceneContext& gc);
  void  update();

private:
  Liquid (const Liquid&);
  Liquid& operator= (const Liquid&);
};

} // namespace WorldObjs

#endif

/* EOF */

