//  Pingus - A free Lemmings clone
//  Copyright (C) 1999 Ingo Ruhnke <grumbel@gmx.de>
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//  
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.

#include "../display/scene_context.hpp"
#include "../pingu.hpp"
#include "../pingu_holder.hpp"
#include "../world.hpp"
#include "../components/smallmap.hpp"
#include "../resource.hpp"
#include "fake_exit.hpp"

namespace WorldObjs {

FakeExit::FakeExit(const FileReader& reader)
  : surface("traps/fake_exit"),
    smallmap_symbol("core/misc/smallmap_exit"),
    smashing(false)
{
  reader.read_vector("position", pos);
  pos -= Vector3f((float)surface.get_width ()/2, (float)surface.get_height ());
}

float
FakeExit::get_z_pos () const
{
  return pos.z;
}

void
FakeExit::draw (SceneContext& gc)
{
  gc.color().draw (surface, pos);
}


void
FakeExit::update ()
{
	PinguHolder* holder = world->get_pingus();
	for (PinguIter pingu = holder->begin (); pingu != holder->end (); ++pingu)
		catch_pingu(*pingu);

	if (smashing)
		surface.update();
}

void
FakeExit::catch_pingu (Pingu* pingu)
{
	if (surface.is_finished())
		smashing = false;

	if (   pingu->get_pos().x > pos.x + 31 && pingu->get_pos().x < pos.x + 31 + 15
      && pingu->get_pos().y > pos.y + 56 && pingu->get_pos().y < pos.y + 56 + 56)
	{
		if (pingu->get_action() != Actions::SPLASHED)
		{
			if (!smashing) 
			{
			surface.restart();
			smashing = true;
			}
	
			if (surface.get_current_frame() == 4)
				pingu->set_action(Actions::SPLASHED);
		}
	}
}

void
FakeExit::draw_smallmap(SmallMap* smallmap)
{
	smallmap->draw_sprite(smallmap_symbol, pos);
}

} // namespace WorldObjs

/* EOF */
