#ifndef _HILDON_HACKS_H_
#define _HILDON_HACKS_H_

#include "pidgin.h"

G_BEGIN_DECLS

#ifdef USE_HILDON
/**
 * Places a widget inside a GtkScrolledWindow. The function is defined as a pass-through so as to be able to
 * accomodate different modifications to a container depending on need.
 *
 * In Hildon's case, its functionality is twofold:
 *
 * 1. It will at least place container inside a GtkScrolledWindow (with policy set to @c GTK_POLICY_AUTOMATIC)
 *    and return the GtkScrolledWindow.
 *
 * 2. If toplevel is given, then it attempts to deal with the bug whereby a GtkScrolledWindow
 *    with @c GTK_POLICY_AUTOMATIC, when placed inside a non-resizable GtkWindow (such as a GtkDialog), tends to
 *    become squashed to its minimum size. This function compensates by initially setting the policy to
 *    @c GTK_POLICY_NEVER, and overriding the GtkScrolledWindow size request to include the size of the scrollbars
 *    and viewport borders. Upon showing the GtkScrolledWindow, the policy is re-set to @c GTK_POLICY_AUTOMATIC.
 *
 *    This will only work on Maemo, because its window manager ensures that no portion of a dialog is ever shown
 *    off-screen, whereas desktop window managers will give the dialog all the size it asks for, even if that means
 *    that it won't fit on the screen.
 *
 * @param container The container to make scrollable.
 * @param toplevel  The toplevel widget (non-resizable window or dialog), or @c NULL
 * @return a GtkScrolledWindow containing a GtkViewport with the widget passed in.
 */
GtkWidget *_pidgin_make_container_scrollable(GtkWidget *container, GtkWidget *toplevel);

void _pidgin_window_set_allow_fullscreen(GtkWidget *window, gboolean can_fullscreen);

void _hildon_hacks_init(void);
void _hildon_hacks_uninit(void);
#else /* !USE_HILDON */
# define _pidgin_make_container_scrollable(container,toplevel) container
# define _pidgin_window_set_allow_fullscreen(window,can_fullscreen)
# define _hildon_hacks_init()
# define _hildon_hacks_uninit()
#endif /* USE_HILDON */

G_END_DECLS

#endif /* !_HILDON_HACKS_H_ */
