/*
 *
 *  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
 *
 *  This file is part of pidgin-carman.
 *
 *  pidgin-carman is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  pidgin-carman is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with pidgin-carman.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef NEED_DBUS_WATCH_GET_UNIX_FD
#define dbus_watch_get_unix_fd dbus_watch_get_fd
#endif

#ifdef DEBUG
#define debug_fprintf(mesg...)     \
	fprintf(stderr, mesg)
#else
#define debug_fprintf(mesg...)
#endif

#define CARMAND_BUS_PATH	"unix:path=/var/run/carmand-dbus-path"

struct infosharing_command {
	/* Direction: out */
	int (*connect) (const char *id);
	int (*disconnect) (const char *id);
	int (*write) (const char *id, double lat, double lon, double alt, double track, double speed, double rpm);
	int (*accept) (const char *id);
	int (*reject) (const char *id);
};

struct infosharing_event {
	/* Direction: in -- asynchronous buddy info */
	int (*authorize) (const char *id, const char *name);
	void (*disconnected) (const char *id);
	int (*data) (const char *id, double lat, double lon, double alt, double track, double speed, double rpm);
	void (*accepted) (const char *id, const char *name);
	void (*rejected) (const char *id);
};

gboolean dbus_init(DBusConnection *conn, const struct infosharing_command *command);
int dbus_init_callbacks(struct infosharing_event *evt);
void dbus_exit(void);
