#!/usr/bin/python
#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#  
#  carman-python is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Lesser General Public License as
#  published by the Free Software Foundation; either version 2.1 of the
#  License, or (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public License
#  along with this program. If not, see <http://www.gnu.org/licenses/>.
#

import gobject
import dbus, sys
import dbus.mainloop.glib

def data_available(lat, lon, alt, speed, track, rpm):
    print "DataAvailable(%lf, %lf, %lf, %ls, %lf, %lf)" % (lat, lon, alt, speed, track, rpm)

def buddy_created(path):
    print "BuddyCreated(%s)" % path

def buddy_removed(path):
    print "BuddyRemoved(%s)" % path

if __name__ == '__main__':

	_id = None

        dbus.mainloop.glib.DBusGMainLoop(set_as_default=True)

        _dbus_address = "unix:path=/var/run/carmand-dbus-path"
        bus = dbus.bus.BusConnection(_dbus_address)
        carman = bus.get_object("org.indt.carmanplugin", "/")

        mgr = dbus.Interface(carman, "org.indt.carmanplugin.Manager")

	if (len(sys.argv) != 2):
		print "request.py <buddy address>"
		sys.exit(0)

        bus.add_signal_receiver(buddy_created,
                                path = "/",
                                dbus_interface = "org.indt.carmanplugin.Manager",
                                signal_name = "BuddyCreated")
        bus.add_signal_receiver(buddy_removed,
                                path = "/",
                                dbus_interface = "org.indt.carmanplugin.Manager",
                                signal_name = "BuddyRemoved")

        bus.add_signal_receiver(data_available,
                                dbus_interface = "org.indt.carmanplugin.Buddy",
                                signal_name = "DataAvailable")

	_id = sys.argv[1]
	print "Requesting authorization for: %s" % _id
	print mgr.RequestAuthorization(_id)
        mainloop = gobject.MainLoop()
        mainloop.run()
