/*
 *
 *  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
 *
 *  This file is part of pidgin-carman.
 *
 *  pidgin-carman is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  pidgin-carman is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with pidgin-carman.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#define PLUGIN_ID "core-carman"

#ifdef DEBUG
#define debug_info(mesg...)	\
	purple_debug_info(PLUGIN_ID, mesg)
#else
#define debug_info(mesg...)
#endif

#define debug_error(mesg...)	\
	purple_debug_error(PLUGIN_ID, mesg)

#define PLUGIN_GREETING_MSG_PATTERN   "^.*cds;ccs;cde;$"
#define PLUGIN_ACCEPTED_MSG_PATTERN   "^.*cds;cca;cde;$"
#define PLUGIN_REJECTED_MSG_PATTERN   "^.*cds;ccr;cde;$"
#define PLUGIN_CLOSE_CONN_MSG_PATTERN "^.*cds;cce;cde;$"
#define PLUGIN_DATA_PATTERN           "^.*cds;dds;(([\\-]*[0-9]+\\.[0-9]+;){6})dde;cde;$"

#define PLUGIN_GREETING_MSG_FMT "I'm trying to share my Carman information with you, but it appears that you don't have the pidgin-carman package installed. If you don't want to share any information, please ignore this message.<br>For more information about carman, please visit: http://openbossa.indt.org/carman<br><span style='color: #ffffff'>cds;ccs;cde;</span>"
#define PLUGIN_ACCEPTED_FMT     "cds;cca;cde;"
#define PLUGIN_REJECTED_FMT     "cds;ccr;cde;"
#define PLUGIN_CLOSE_CONN_FMT   "cds;cce;cde;"
#define PLUGIN_DATA_FMT         "cds;dds;%lf;%lf;%lf;%lf;%lf;%lf;dde;cde;"
