#include "View/People.h"

#include <Lum/Base/Util.h>

#include <Lum/Button.h>
#include <Lum/Menu.h>

#include <Lum/Model/Selection.h>

#include "Person.h"

#include "../Database.h"

#include <iostream>

namespace Views {

  class PeopleEntryDataProvider : public PeopleEntryModel::DataProvider
  {
  public:
    std::wstring GetString(const PeopleEntryModel::Iterator& iter, size_t column) const
    {
      switch (column) {
      case 1:
        return (*iter)->person->GetAttribute(::Data::Person::PersonType::name);
      case 2:
        return (*iter)->person->GetAttribute(::Data::Person::PersonType::surename);
      default:
        return L"";
      }
    }
  };

  class PeopleEntryComparator : public PeopleEntryModel::Comparator
  {
  public:
    bool operator()(const PeopleEntryModel::ElementType& a,
                    const PeopleEntryModel::ElementType& b,
                    size_t column, bool down) const
    {
      if (a->person->GetAttribute(::Data::Person::PersonType::name)==b->person->GetAttribute(::Data::Person::PersonType::name)) {
        return a->person->GetAttribute(::Data::Person::PersonType::surename)<b->person->GetAttribute(::Data::Person::PersonType::surename);
      }
      else {
        return a->person->GetAttribute(::Data::Person::PersonType::name)<b->person->GetAttribute(::Data::Person::PersonType::name);
      }
    }
  };

  People::People()
  : View(L"People"),
    viewAction(new Lum::Model::Action),
    addAction(new Lum::Model::Action),
    deleteAction(new Lum::Model::Action),
    model(new PeopleEntryModel(new PeopleEntryDataProvider(),
                               new PeopleEntryComparator())),
    table(NULL),
    top(NULL)
  {
    Observe(viewAction);
    Observe(addAction);
    Observe(deleteAction);
  }

  People::~People()
  {
    delete top;
  }

  void People::FillList()
  {
    model->Off();

    model->Clear();

    ::Base::DataConstIterator iter;

    iter=database->database.begin();
    while (iter!=database->database.end()) {
      ::Data::PersonPtr person;

      if ((person=dynamic_cast< ::Data::PersonPtr>(*iter))!=NULL) {
        model->Append(new PeopleEntry(person));
      }

      iter++;
    }

    model->Sort(1);

    model->On();
  }

  bool People::VisitChildren(Lum::Visitor &visitor, bool onlyVisible)
  {
    if (top!=NULL) {
      return visitor.Visit(top);
    }

    return true;
  }

  void People::CalcSize()
  {
    Lum::Menu             *menu;
    Lum::Model::HeaderRef headerModel;

    top=Lum::VPanel::Create(true,true);
    top->SetParent(this);

    headerModel=new Lum::Model::HeaderImpl();
    headerModel->AddColumn(L"Name",Lum::Base::Size::stdCharWidth,15,true);
    headerModel->AddColumn(L"Surename",Lum::Base::Size::stdCharWidth,15);

    table=new Lum::Table();
    table->SetFlex(true,true);
    table->SetShowHeader(true);
    table->SetModel(model);
    table->SetHeaderModel(headerModel);
    table->SetSelection(new Lum::Model::SingleLineSelection());
    table->SetDoubleClickAction(viewAction);

    menu=new Lum::Menu();
    menu->SetParent(GetWindow());
    menu->AddActionItem(L"View",viewAction);
    menu->AddActionItem(L"Add",addAction);
    menu->AddActionItem(L"Delete",deleteAction);
    table->SetMenu(menu->GetWindow());

    top->Add(table);

    top->CalcSize();

    width=top->GetOWidth();
    height=top->GetOHeight();
    minWidth=top->GetOMinWidth();
    minHeight=top->GetOMinHeight();
    maxWidth=top->GetOMaxWidth();
    maxHeight=top->GetOMaxHeight();

    View::CalcSize();
  }

  void People::Layout()
  {
    top->Resize(width,height);
    top->Move(x,y);

    View::Layout();
  }

  void People::Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg)
  {
    if (model==viewAction && viewAction->IsFinished()) {
      if (table->GetTableView()->GetSelection()->HasSelection()) {
        size_t line;
        Person::Data *data;

        line=dynamic_cast<Lum::Model::SingleLineSelection*>(table->GetTableView()->GetSelection())->GetLine();
        data=new ::Base::View::Data(dynamic_cast< PeopleEntry*>(this->model->GetEntry(line))->person);
        GUI::GetInstance()->ShowView(L"Person",data);
      }
    }
    else if (model==addAction && addAction->IsFinished()) {
      Person::Data *data;

      data=new ::Base::View::Data(new ::Data::Person());
      GUI::GetInstance()->ShowView(L"Person",data);
    }
    else if (model==deleteAction && deleteAction->IsFinished()) {
      if (table->GetTableView()->GetSelection()->HasSelection()) {
        size_t         line;
        ::Data::Person *person;

        line=dynamic_cast<Lum::Model::SingleLineSelection*>(table->GetTableView()->GetSelection())->GetLine();
        person=dynamic_cast< PeopleEntry*>(this->model->GetEntry(line))->person;
        database->Remove(person);
        FillList();
      }
    }
    else {
      View::Resync(model,msg);
    }
  }

  void People::Load(::Base::View::DataPtr data=NULL)
  {
    FillList();
  }

  void People::Vanish()
  {
    model->Clear();
  }
}
