#include "View/Notes.h"

#include <Lum/Base/Util.h>

#include <Lum/Button.h>
#include <Lum/Menu.h>
#include <Lum/Space.h>

#include <Lum/Model/Selection.h>

#include "Note.h"

#include "../Database.h"

#include <iostream>

namespace Views {

  class NotesEntryDataProvider : public NotesEntryModel::DataProvider
  {
  public:
    std::wstring GetString(const NotesEntryModel::Iterator& iter, size_t column) const
    {
      std::wstring result;
      size_t       pos;

      switch (column) {
      case 1:
        result=(*iter)->note->GetAttribute(::Data::Note::NoteType::text);
        pos=result.find(L'\n');
        if (pos!=std::wstring::npos) {
          return result.substr(0,pos)+L"...";
        }
        else {
          return result;
        }
      default:
        return L"";
      }
    }
  };

  class NotesEntryComparator : public NotesEntryModel::Comparator
  {
  public:
    bool operator()(const NotesEntryModel::ElementType& a,
                    const NotesEntryModel::ElementType& b,
                    size_t column, bool down) const
    {
      return a->note->GetAttribute(::Data::Note::NoteType::text)<b->note->GetAttribute(::Data::Note::NoteType::text);
    }
  };


  Notes::Notes()
  : View(L"Notes"),
    viewAction(new Lum::Model::Action),
    addAction(new Lum::Model::Action),
    deleteAction(new Lum::Model::Action),
    model(new NotesEntryModel(new NotesEntryDataProvider(),
                              new NotesEntryComparator())),
    table(NULL),top(NULL)
  {
    Observe(viewAction);
    Observe(addAction);
    Observe(deleteAction);
  }

  Notes::~Notes()
  {
    delete top;
  }

  void Notes::FillList()
  {
    model->Off();

    model->Clear();

    ::Base::DataConstIterator iter;

    iter=database->database.begin();
    while (iter!=database->database.end()) {
      ::Data::NotePtr note;

      if ((note=dynamic_cast< ::Data::NotePtr>(*iter))!=NULL) {
        model->Append(new NotesEntry(note));
      }

      iter++;
    }

    model->Sort(1);

    model->On();
  }

  bool Notes::VisitChildren(Lum::Visitor &visitor, bool onlyVisible)
  {
    if (top!=NULL) {
      return visitor.Visit(top);
    }

    return true;
  }

  void Notes::CalcSize()
  {
    Lum::Menu             *menu;
    Lum::Model::HeaderRef headerModel;

    top=Lum::VPanel::Create(true,true);
    top->SetParent(this);

    headerModel=new Lum::Model::HeaderImpl();
    headerModel->AddColumn(L"Text",Lum::Base::Size::stdCharWidth,10);

    table=new Lum::Table();
    table->SetFlex(true,true);
    table->SetShowHeader(true);
    table->SetModel(model);
    table->SetHeaderModel(headerModel);
    table->SetSelection(new Lum::Model::SingleLineSelection());
    table->SetDoubleClickAction(viewAction);

    menu=new Lum::Menu();
    menu->SetParent(GetWindow());
    menu->AddActionItem(L"View",viewAction);
    menu->AddActionItem(L"Add",addAction);
    menu->AddActionItem(L"Delete",deleteAction);
    table->SetMenu(menu->GetWindow());

    top->Add(table);

    top->CalcSize();

    width=top->GetOWidth();
    height=top->GetOHeight();
    minWidth=top->GetOMinWidth();
    minHeight=top->GetOMinHeight();
    maxWidth=top->GetOMaxWidth();
    maxHeight=top->GetOMaxHeight();

    View::CalcSize();
  }

  void Notes::Layout()
  {
    top->Resize(width,height);
    top->Move(x,y);

    View::Layout();
  }

  void Notes::Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg)
  {
    if (model==viewAction && viewAction->IsFinished()) {
      if (table->GetTableView()->GetSelection()->HasSelection()) {
        size_t     line;
        Note::Data *data;

        line=dynamic_cast<Lum::Model::SingleLineSelection*>(table->GetTableView()->GetSelection())->GetLine();
        data=new ::Base::View::Data(dynamic_cast< NotesEntry*>(this->model->GetEntry(line))->note);
        GUI::GetInstance()->ShowView(L"Note",data);
      }
    }
    else if (model==addAction && addAction->IsFinished()) {
      Note::Data *data;

      data=new ::Base::View::Data(new ::Data::Note());
      GUI::GetInstance()->ShowView(L"Note",data);
    }
    else if (model==deleteAction && deleteAction->IsFinished()) {
      if (table->GetTableView()->GetSelection()->HasSelection()) {
        size_t         line;
        ::Data::Note   *note;

        line=dynamic_cast<Lum::Model::SingleLineSelection*>(table->GetTableView()->GetSelection())->GetLine();
        note=dynamic_cast< NotesEntry*>(this->model->GetEntry(line))->note;
        database->Remove(note);
        FillList();
      }
    }
    else {
      View::Resync(model,msg);
    }
  }

  void Notes::Load(::Base::View::DataPtr data=NULL)
  {
    FillList();
  }

  void Notes::Vanish()
  {
    model->Clear();
  }
}
