#include <iostream>

#include <Lum/Base/Path.h>

#include <Lum/OS/Probe.h>

#include "Database.h"
#include "GUI.h"

#include "Data.h"

// Data views
#include "View/Date.h"
#include "View/EMail.h"
#include "View/Location.h"
#include "View/MSISDN.h"
#include "View/Note.h"
#include "View/Person.h"

// Selectors
#include "View/Dates.h"
#include "View/Notes.h"
#include "View/People.h"
#include "View/Search.h"
#include "View/Selector.h"

// Datatypes
#include "Data/Date.h"
#include "Data/EMail.h"
#include "Data/Location.h"
#include "Data/MSISDN.h"
#include "Data/Note.h"
#include "Data/Person.h"

int main(int argc, char* argv[])
{
  Base::Type::RegisterType(Data::Date::dateType);
  Base::Type::RegisterType(Data::EMail::emailType);
  Base::Type::RegisterType(Data::Location::locationType);
  Base::Type::RegisterType(Data::MSISDN::msisdnType);
  Base::Type::RegisterType(Data::Note::noteType);
  Base::Type::RegisterType(Data::Person::personType);

  if (Lum::OS::prober->Open(L"PID",argc,argv)) {
    Views::DefaultSelectorPtr selector;
    Base::ViewPtr             view;
    GUI*                      window;

    /*ignore*/ database->Load(Lum::Base::Path::GetApplicationConfigPath());

    window=GUI::GetInstance();

    selector=new Views::DefaultSelector();
    window->RegisterDefaultView(selector);
    window->RegisterView(selector);

    // Views

    view=new Views::Date;
    window->RegisterView(view);

    view=new Views::EMail;
    window->RegisterView(view);

    view=new Views::Location;
    window->RegisterView(view);

    view=new Views::MSISDN;
    window->RegisterView(view);

    view=new Views::Note;
    window->RegisterView(view);

    view=new Views::Person;
    window->RegisterView(view);

    // Selectors

    view=new Views::Dates;
    selector->RegisterSelector(view);
    window->RegisterView(view);

    view=new Views::Notes;
    selector->RegisterSelector(view);
    window->RegisterView(view);

    view=new Views::People;
    selector->RegisterSelector(view);
    window->RegisterView(view);

    view=new Views::Search;
    selector->RegisterSelector(view);
    window->RegisterView(view);

    window->SetTitle(L"PID");

    if (window->Open()) {
      window->SetExitAction(window->GetClosedAction());
      window->EventLoop();
      window->Close();
    }

    delete window;

    Lum::OS::display->Close();

    database->Save(Lum::Base::Path::GetApplicationConfigPath());
  }
}

