/*
 *  Copyright (c) 2008 Andrew Olmsted <andrew.olmsted@gmail.com>
 *
 *  Parts of this file are based on Command Navigator which is
 *  Copyright (c) 2007-2008 Jiri Benc <jbenc@upir.cz>
 *  Parts of this file are based on hello-world-app
 *  Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <libosso.h>
#include <dirent.h>
#include <hildon/hildon.h>
#include <libintl.h>
#include <locale.h>
#include <values.h>

#define HOME_DIR g_get_home_dir()

#include "personal-launcher-setup.h"

void select_icon(GtkButton *button, PersonalLauncherSetup *setup);
static void dnd_set_data(GtkWidget *view, GdkDragContext *context, int x, int y, GtkSelectionData *selection_data, guint info, guint time, PersonalLauncherSetup *setup);

void menu_selection_change(GtkTreeView *treeView, PersonalLauncherSetup *setup)
{
	GtkTreeSelection *selection=gtk_tree_view_get_selection(treeView);
	GtkTreeModel *model=gtk_tree_view_get_model(treeView);
	GtkTreeIter iter;
	gchar *name=NULL,*exec=NULL,*dbus=NULL;
	gchar *iconName=NULL;
	
	gtk_tree_selection_get_selected(selection,&model,&iter);
	gtk_tree_model_get(model,&iter,1,&name,2,&exec,3,&iconName,6,&dbus,-1);
	
	if (name==NULL)
		name="";
	if (exec==NULL)
		exec="";
	if (dbus==NULL)
		dbus="";
	if (iconName==NULL)
		iconName="";
	
	gtk_label_set_label(GTK_LABEL(setup->nameLabel),gettext(name));
	gtk_label_set_label(GTK_LABEL(setup->execLabel),exec);
	gtk_label_set_markup(GTK_LABEL(setup->execLabel),g_strconcat("<small>",exec,"</small>",NULL));
	gtk_label_set_label(GTK_LABEL(setup->dbusLabel),dbus);
	gtk_label_set_markup(GTK_LABEL(setup->dbusLabel),g_strconcat("<small>",dbus,"</small>",NULL));
}

void desktop_selection_change(GtkTreeView *treeView, PersonalLauncherSetup *setup)
{
	GtkTreeSelection *selection=gtk_tree_view_get_selection(treeView);
	GtkTreeModel *model=gtk_tree_view_get_model(treeView);
	GtkTreeIter iter;
	gchar *name=NULL,*exec=NULL,*dbus=NULL;
	
	gtk_tree_selection_get_selected(selection,&model,&iter);
	gtk_tree_model_get(model,&iter,1,&name,2,&exec,6,&dbus,-1);

	if (name==NULL)
		name="";
	if (exec==NULL)
		exec="";
	if (dbus==NULL)
		dbus="";
	
	gtk_label_set_label(GTK_LABEL(setup->nameLabel),gettext(name));
	gtk_label_set_label(GTK_LABEL(setup->execLabel),exec);
	gtk_label_set_markup(GTK_LABEL(setup->execLabel),g_strconcat("<small>",exec,"</small>",NULL));
	gtk_label_set_label(GTK_LABEL(setup->dbusLabel),dbus);
	gtk_label_set_markup(GTK_LABEL(setup->dbusLabel),g_strconcat("<small>",dbus,"</small>",NULL));
}

static GtkTreeView *setup_make_view(PersonalLauncherSetup *setup)
{
	GtkTreeView *res;
	gchar* filename;
	gboolean fileExists;
	GKeyFile* keyFile;

	setup->entryList=gtk_list_store_new(8,GDK_TYPE_PIXBUF,G_TYPE_STRING,G_TYPE_STRING,G_TYPE_STRING,G_TYPE_STRING,G_TYPE_STRING,G_TYPE_STRING,GDK_TYPE_PIXBUF);

	keyFile=g_key_file_new();
	filename=g_strdup(HOME_DIR);
	filename=g_strconcat(filename,"/.personal_launcher.rc",NULL);
	fileExists=g_key_file_load_from_file(keyFile,filename,G_KEY_FILE_KEEP_COMMENTS,NULL);
	if (fileExists)
	{
		int i=0;
		char entry[5];
		gboolean found;
		snprintf(entry,5,"%d",i);
		found=g_key_file_has_group(keyFile,entry);
		while (found)
		{
			GtkIconTheme *icon_theme;
			GdkPixbuf *icon=NULL;
			GdkPixbuf *largeIcon=NULL;
			GdkPixbuf *smallIcon=NULL;
			gchar* appName=NULL;
			gchar* iconName=NULL;
			gchar* executable=NULL;
			gchar* service=NULL;
			gchar* runAsRoot=NULL;
			gchar* runInTerm=NULL;
			sprintf(entry,"%d",i);
			appName=g_key_file_get_string(keyFile,entry,"app name",NULL);
			iconName=g_key_file_get_string(keyFile,entry,"icon name",NULL);
			executable=g_key_file_get_string(keyFile,entry,"executable",NULL);
			runAsRoot=g_key_file_get_string(keyFile,entry,"run as root",NULL);
			if (runAsRoot==NULL)
				runAsRoot="false";
			runInTerm=g_key_file_get_string(keyFile,entry,"run in term",NULL);
			if (runInTerm==NULL)
				runInTerm="false";
			service=g_key_file_get_string(keyFile,entry,"service",NULL);

			icon_theme = gtk_icon_theme_get_default ();
			icon=gtk_icon_theme_load_icon(icon_theme,iconName,64,0,NULL);
			if (icon==NULL)
			{
			  icon=gtk_icon_theme_load_icon(icon_theme,"qgn_list_gene_default_app",64,0,NULL);
			}
			largeIcon=gdk_pixbuf_scale_simple(icon,64,64,GDK_INTERP_NEAREST);
			icon=gtk_icon_theme_load_icon(icon_theme,iconName,26,0,NULL);
			if (icon==NULL)
			{
			  icon=gtk_icon_theme_load_icon(icon_theme,"qgn_list_gene_default_app",26,0,NULL);
			}
			smallIcon=gdk_pixbuf_scale_simple(icon,26,26,GDK_INTERP_NEAREST);

			gtk_list_store_append(setup->entryList, &setup->entryIter);

			gtk_list_store_set(setup->entryList, &setup->entryIter, 0, largeIcon,1,appName,2,executable,3,iconName,4,runAsRoot,5,runInTerm,6,service,7,smallIcon,-1);

	    //g_object_unref(G_OBJECT(largeIcon));
	    //g_object_unref(G_OBJECT(smallIcon));
	    snprintf(entry,5,"%d",++i);
	    found=g_key_file_has_group(keyFile,entry);
	  }
	}
	g_key_file_free(keyFile);
    
	res = GTK_TREE_VIEW(gtk_tree_view_new_with_model(GTK_TREE_MODEL(setup->entryList)));
	GtkCellRenderer *render=gtk_cell_renderer_pixbuf_new();
	gtk_tree_view_append_column(res,gtk_tree_view_column_new_with_attributes(NULL,render,"pixbuf",0,NULL));
	render=gtk_cell_renderer_text_new();
	g_object_set(G_OBJECT(render),"ellipsize",PANGO_ELLIPSIZE_END,NULL);
	gtk_tree_view_append_column(res,gtk_tree_view_column_new_with_attributes(NULL,render,"text",1,NULL));
	gtk_tree_selection_set_mode(gtk_tree_view_get_selection(res),GTK_SELECTION_BROWSE);
	g_signal_connect(G_OBJECT(res),"cursor-changed",G_CALLBACK(menu_selection_change),setup);
	gtk_tree_view_set_reorderable(GTK_TREE_VIEW(res),TRUE);
	gtk_tree_view_set_rules_hint(res,TRUE);

	if (1)
	{
		static GtkTargetEntry targetentries[] =
		{
			{ "GTK_TREE_MODEL_ROW", 0, 0 },
			{ "application row", 0, 1},
		};
		
		gtk_tree_view_enable_model_drag_dest(res,targetentries,2,GDK_ACTION_COPY);
		g_signal_connect(res,"drag_data_received",G_CALLBACK(dnd_set_data),setup);
	}

	return res;
}

void icon_selection_change(GtkIconView *iconView, PersonalLauncherSetup *setup)
{
	GList *list=gtk_icon_view_get_selected_items(iconView);
	GtkTreeModel *model=gtk_icon_view_get_model(iconView);
	GtkTreeIter iter;
	gchar *name;
	
	gtk_tree_model_get_iter(model,&iter,g_list_nth_data(list,0));
	gtk_tree_model_get(model,&iter,1,&name,-1);
	
	gtk_label_set_label(GTK_LABEL(setup->nameLabel),gettext(name));
	
	g_list_foreach(list,(GFunc)gtk_tree_path_free,NULL);
	g_list_free(list);
}

/*void desktop_select_process(PersonalLauncherSetup *setup)
{
	GtkTreeIter iter;
	gchar *appName,*iconName,*executable,*service;
	GdkPixbuf *icon;
	GList *list=gtk_icon_view_get_selected_items(GTK_ICON_VIEW(setup->iconView));
	GtkTreeModel *model=gtk_icon_view_get_model(GTK_ICON_VIEW(setup->iconView));

	gtk_tree_model_get_iter(model,&iter,g_list_nth_data(list,0));
	gtk_tree_model_get(model,&iter,0,&icon,1,&appName,2,&executable,3,&iconName,4,&service,-1);
	gtk_list_store_append(setup->entryList, &setup->entryIter);
	gtk_list_store_set(setup->entryList,&setup->entryIter,0,icon,1,appName,2,executable,3,iconName,4,"false",5,"false",6,service,-1);
	g_object_unref(G_OBJECT(icon));
	g_list_foreach(list,(GFunc)gtk_tree_path_free,NULL);
	g_list_free(list);
}*/

static GtkTreeView *setup_make_icon_view(PersonalLauncherSetup *setup)
{
	DIR *d;
	struct dirent *dir;
	GtkListStore *store;
	GtkTreeIter iter;
	gboolean fileExists;
	GKeyFile* keyFile;
	GtkTreeModel* sort;
	GtkTreeView *res;

	store=gtk_list_store_new(8,GDK_TYPE_PIXBUF,G_TYPE_STRING,G_TYPE_STRING,G_TYPE_STRING,G_TYPE_STRING,G_TYPE_STRING,G_TYPE_STRING,GDK_TYPE_PIXBUF);
	d=opendir("/usr/share/applications/hildon/");
	if (d)
	{
		while ((dir=readdir(d)) != NULL)
		{
			if ((g_strrstr(dir->d_name,".desktop"))||(g_strrstr(dir->d_name,".DESKTOP")))
			{
				gchar *group;
				gchar *appName,*iconName,*executable,*service;
				GtkIconTheme *icon_theme;
				GdkPixbuf *icon=NULL;
				GdkPixbuf *smallIcon=NULL;
				gchar *filename;
				filename=g_strconcat("/usr/share/applications/hildon/",dir->d_name,NULL);
				keyFile=g_key_file_new();
				fileExists=g_key_file_load_from_file(keyFile,filename,G_KEY_FILE_KEEP_COMMENTS,NULL);
				group=g_key_file_get_start_group(keyFile);
				appName=g_key_file_get_string(keyFile,group,"Name",NULL);
				iconName=g_key_file_get_string(keyFile,group,"Icon",NULL);
				executable=g_key_file_get_string(keyFile,group,"Exec",NULL);
				service=g_key_file_get_string(keyFile,group,"X-Osso-Service",NULL);
				if (g_strcasecmp(iconName,"")!=0)
				{
					icon_theme = gtk_icon_theme_get_default ();
					icon=gtk_icon_theme_load_icon(icon_theme,iconName,64,0,NULL);
					if (icon==NULL)
					{
					  icon=gtk_icon_theme_load_icon(icon_theme,"qgn_list_gene_default_app",64,0,NULL);
					}
					smallIcon=gtk_icon_theme_load_icon(icon_theme,iconName,26,0,NULL);
					if (smallIcon==NULL)
					{
					  smallIcon=gtk_icon_theme_load_icon(icon_theme,"qgn_list_gene_default_app",26,0,NULL);
					}
					//icon=gdk_pixbuf_scale_simple(icon,64,64,GDK_INTERP_NEAREST);
				}

				gtk_list_store_append(store, &iter);
				gtk_list_store_set(store, &iter,0,icon,1,gettext(appName),2,executable,3,iconName,4,"false",5,"false",6,service,7,smallIcon,-1);
				//g_object_unref(G_OBJECT(icon));
				//g_object_unref(G_OBJECT(smallIcon));
				g_key_file_free(keyFile);
			}
		}
	}
    
	res = GTK_TREE_VIEW(gtk_tree_view_new_with_model(GTK_TREE_MODEL(store)));
	GtkCellRenderer *render=gtk_cell_renderer_pixbuf_new();
	gtk_tree_view_append_column(res,gtk_tree_view_column_new_with_attributes(NULL,render,"pixbuf",0,NULL));
	render=gtk_cell_renderer_text_new();
	g_object_set(G_OBJECT(render),"ellipsize",PANGO_ELLIPSIZE_END,NULL);
	gtk_tree_view_append_column(res,gtk_tree_view_column_new_with_attributes(NULL,render,"text",1,NULL));	gtk_tree_selection_set_mode(gtk_tree_view_get_selection(res),GTK_SELECTION_BROWSE);
	g_signal_connect(G_OBJECT(res),"cursor-changed",G_CALLBACK(desktop_selection_change),setup);
	sort=gtk_tree_model_sort_new_with_model(GTK_TREE_MODEL(store));
	gtk_tree_sortable_set_sort_column_id(GTK_TREE_SORTABLE(sort),1,GTK_SORT_ASCENDING);
	gtk_tree_view_set_model(res,sort);
	gtk_tree_view_set_rules_hint(res,TRUE);
	
	if (1)
	{
		static GtkTargetEntry targetentries[] =
		{
			{ "application row", 0, 1 },
		};
		gtk_tree_view_enable_model_drag_source(res,GDK_BUTTON1_MASK,targetentries,1,GDK_ACTION_COPY);
		//g_signal_connect(G_OBJECT(res),"drag_motion",G_CALLBACK(dnd_motion),setup);
	}
	
	return res;
}

void change_context(GtkComboBox *combo, PersonalLauncherSetup *setup)
{
	GtkWidget *dialog;
	GtkWidget *button;
	button=gtk_button_new();
	setup->context=gtk_combo_box_get_active_text(combo);
	dialog=gtk_widget_get_toplevel(GTK_WIDGET(combo));
	gtk_widget_destroy(GTK_WIDGET(dialog));
	select_icon(GTK_BUTTON(button),setup);
}

void icon_select_process(PersonalLauncherSetup *setup)
{
	gchar *iconName;
	GtkTreeIter iter;
	GList *list=gtk_icon_view_get_selected_items(GTK_ICON_VIEW(setup->iconView));
	GtkTreeModel *model=gtk_icon_view_get_model(GTK_ICON_VIEW(setup->iconView));

	gtk_tree_model_get_iter(model,&iter,g_list_nth_data(list,0));
	gtk_tree_model_get(model,&iter,1,&iconName,-1);
	gtk_image_set_from_icon_name(GTK_IMAGE(setup->iconPreview),iconName,GTK_ICON_SIZE_DIALOG);
	g_list_foreach(list,(GFunc)gtk_tree_path_free,NULL);
	g_list_free(list);
}

void icon_select_activate(GtkIconView *iconView, GtkTreePath *path, PersonalLauncherSetup *setup)
{
	icon_select_process(setup);
	gtk_dialog_response(GTK_DIALOG(setup->selectDialog),GTK_RESPONSE_CANCEL);
}

void select_icon(GtkButton *button, PersonalLauncherSetup *setup)
{
	GtkIconTheme *iconTheme;
	GList *iconList;
	GtkListStore *store;
	GtkTreeIter iter;
	GtkWidget *scroll;
	GtkWidget *typeCombo;
	GtkWidget *caption;
	GtkWidget *vbox;
	int i,result;
	GtkTreeModel* sort;
	GtkTreePath *path;

	setup->selectDialog = gtk_dialog_new();
	if (!setup->selectDialog)
		return;
	gtk_window_set_title(GTK_WINDOW(setup->selectDialog), "Select Icon");
	gtk_window_set_modal(GTK_WINDOW(setup->selectDialog), TRUE);

	button = GTK_BUTTON(gtk_button_new_with_label("OK"));
	gtk_dialog_add_action_widget(GTK_DIALOG(setup->selectDialog), GTK_WIDGET(button), GTK_RESPONSE_ACCEPT);
	GTK_WIDGET_SET_FLAGS(GTK_WIDGET(button), GTK_CAN_DEFAULT);
	gtk_widget_grab_default(GTK_WIDGET(button));
	gtk_dialog_add_action_widget(GTK_DIALOG(setup->selectDialog), gtk_button_new_with_label("Cancel"), GTK_RESPONSE_REJECT);

	vbox=gtk_vbox_new(FALSE,0);
	typeCombo=gtk_combo_box_new_text();
	gtk_combo_box_append_text(GTK_COMBO_BOX(typeCombo),"Applications");
	if (g_strcasecmp(setup->context,"Applications")==0)
		gtk_combo_box_set_active(GTK_COMBO_BOX(typeCombo),0);
	gtk_combo_box_append_text(GTK_COMBO_BOX(typeCombo),"Devices");
	if (g_strcasecmp(setup->context,"Devices")==0)
		gtk_combo_box_set_active(GTK_COMBO_BOX(typeCombo),1);
	gtk_combo_box_append_text(GTK_COMBO_BOX(typeCombo),"FileSystems");
	if (g_strcasecmp(setup->context,"FileSystems")==0)
		gtk_combo_box_set_active(GTK_COMBO_BOX(typeCombo),2);
	gtk_combo_box_append_text(GTK_COMBO_BOX(typeCombo),"MimeTypes");
	if (g_strcasecmp(setup->context,"MimeTypes")==0)
		gtk_combo_box_set_active(GTK_COMBO_BOX(typeCombo),3);
	gtk_combo_box_append_text(GTK_COMBO_BOX(typeCombo),"hildon");
	if (g_strcasecmp(setup->context,"hildon")==0)
		gtk_combo_box_set_active(GTK_COMBO_BOX(typeCombo),4);
	g_signal_connect(G_OBJECT(typeCombo),"changed",G_CALLBACK(change_context),setup);

	caption=hildon_caption_new(NULL,"Type of icon",typeCombo,NULL,HILDON_CAPTION_MANDATORY);
	gtk_box_pack_start(GTK_BOX(vbox),caption,FALSE,FALSE,0);

	store=gtk_list_store_new(2,GDK_TYPE_PIXBUF,G_TYPE_STRING);

	iconTheme = gtk_icon_theme_get_default ();
	iconList=gtk_icon_theme_list_icons(iconTheme,setup->context);

	for (i=0;i<g_list_length(iconList);i++)
	{
		gchar* element;
		GdkPixbuf *icon;
		element=g_list_nth_data(iconList,i);
		icon=gtk_icon_theme_load_icon(iconTheme,element,40,0,NULL);
		icon=gdk_pixbuf_scale_simple(icon,40,40,GDK_INTERP_NEAREST);
		gtk_list_store_append(store, &iter);
		gtk_list_store_set(store, &iter,0,icon,1,element,-1);
		g_free(element);
		g_object_unref(G_OBJECT(icon));
	}
	g_list_free(iconList);
    
	setup->iconView=gtk_icon_view_new();
	gtk_icon_view_set_pixbuf_column(GTK_ICON_VIEW(setup->iconView),0);
	g_signal_connect(G_OBJECT(setup->iconView),"selection-changed",G_CALLBACK(icon_selection_change),setup);
	g_signal_connect(G_OBJECT(setup->iconView),"item-activated",G_CALLBACK(icon_select_activate),setup);

	sort=gtk_tree_model_sort_new_with_model(GTK_TREE_MODEL(store));
	gtk_tree_sortable_set_sort_column_id(GTK_TREE_SORTABLE(sort),1,GTK_SORT_ASCENDING);
	gtk_icon_view_set_model(GTK_ICON_VIEW(setup->iconView),sort);
	gtk_icon_view_set_selection_mode(GTK_ICON_VIEW(setup->iconView),GTK_SELECTION_BROWSE);
	scroll = gtk_scrolled_window_new(NULL, GTK_ADJUSTMENT(gtk_adjustment_new(0, 0, 25, 0, 0, 0)));
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
	gtk_widget_set_size_request(GTK_WIDGET(scroll), 400, 270);
	gtk_container_add(GTK_CONTAINER(scroll), GTK_WIDGET(setup->iconView));

	gtk_box_pack_start(GTK_BOX(vbox),scroll,FALSE,FALSE,0);
	setup->nameLabel=gtk_label_new("Icon name");
	gtk_misc_set_alignment(GTK_MISC(setup->nameLabel),0,0.5);
	caption=hildon_caption_new(NULL,"Icon name",setup->nameLabel,NULL,HILDON_CAPTION_MANDATORY);
	gtk_box_pack_start(GTK_BOX(vbox),caption,FALSE,FALSE,0);
	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(setup->selectDialog)->vbox), vbox);
	gtk_widget_show_all(GTK_WIDGET(setup->selectDialog));
	gtk_widget_grab_focus(setup->iconView);
	gtk_tree_model_get_iter_first(sort,&iter);
	path=gtk_tree_model_get_path(sort,&iter);
	gtk_icon_view_select_path(GTK_ICON_VIEW(setup->iconView),path);
	result = gtk_dialog_run(GTK_DIALOG(setup->selectDialog));
	if (result == GTK_RESPONSE_ACCEPT) {
		/*get the selected row and add the pertinant data to the entryList*/
		icon_select_process(setup);
	}
	gtk_widget_destroy(GTK_WIDGET(setup->selectDialog));
}

static void edit_heading(GtkTreeIter iter, PersonalLauncherSetup *setup)
{
	GtkWidget *dialog;
	GtkWidget *caption,*name;
	gchar *appName;
	
	dialog=gtk_dialog_new_with_buttons("Edit heading",NULL,GTK_DIALOG_MODAL,GTK_STOCK_OK,GTK_RESPONSE_ACCEPT,GTK_STOCK_CANCEL,GTK_RESPONSE_CANCEL,NULL);
	name=gtk_entry_new();
	caption=hildon_caption_new(NULL,"Heading text",name,NULL,HILDON_CAPTION_MANDATORY);
	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(dialog)->vbox),caption);
	gtk_widget_show_all(dialog);
	
	gtk_tree_model_get(gtk_tree_view_get_model(setup->view),&iter,1,&appName,-1);
	gtk_entry_set_text(GTK_ENTRY(name),appName);
	
	if (gtk_dialog_run(GTK_DIALOG(dialog))==GTK_RESPONSE_ACCEPT)
	{
		gtk_list_store_set(GTK_LIST_STORE(setup->entryList),&iter,1,gtk_entry_get_text(GTK_ENTRY(name)),-1);
	}
	gtk_widget_destroy(dialog);
}

static void dialog_add_edit(GtkTreeIter iter, GtkTreeIter *sibling, gboolean edit, PersonalLauncherSetup *setup)
{
	GtkDialog *dialog;
	GtkWidget *button, *vbox;
	GtkWidget *hbox, *vbox2;
	GtkWidget *caption, *align;
	GtkWidget *appNameEntry, *executableEntry, *iconButton;
	GtkWidget *serviceEntry;
	GtkWidget *termCheckBox, *rootCheckBox;
	GtkWidget *scroll;
	int res;

	if (edit)
	{
		gchar *appName,*iconName,*executable,*service;
		gchar *runAsRoot,*runInTerm;
		gtk_tree_model_get(gtk_tree_view_get_model(setup->view),&iter,1,&appName,2,&executable,3,&iconName,4,&runAsRoot,5,&runInTerm,6,&service,-1);
		
		if (g_strcasecmp(appName,"(SEPARATOR)")==0)
		{
			return;
		}
		if ((g_strcasecmp(iconName,"")==0)&&(g_strcasecmp(executable,"")==0)&&(g_strcasecmp(service,"")==0))
		{
			edit_heading(iter,setup);
			return;
		}
	}

	dialog = GTK_DIALOG(gtk_dialog_new());
	if (!dialog)
		return;
	gtk_window_set_transient_for(GTK_WINDOW(dialog), setup->setupwin);
	gtk_window_set_title(GTK_WINDOW(dialog), edit ? "Edit command" : "Add command");
	gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);

	button = gtk_button_new_with_label("OK");
	gtk_dialog_add_action_widget(dialog, button, GTK_RESPONSE_ACCEPT);
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	gtk_widget_grab_default(button);
	gtk_dialog_add_action_widget(dialog, gtk_button_new_with_label("Cancel"), GTK_RESPONSE_REJECT);

	vbox=gtk_vbox_new(FALSE,0);
	scroll=gtk_scrolled_window_new(NULL,NULL);
	hbox=gtk_hbox_new(FALSE,0);
	
	caption=gtk_label_new("Name of the menu entry");
	gtk_label_set_markup(GTK_LABEL(caption),"<small>Name of the menu entry</small>");
	gtk_box_pack_start(GTK_BOX(hbox),caption,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),gtk_alignment_new(1.0,0.0,0.0,0.0),TRUE,TRUE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
	appNameEntry=gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(vbox),appNameEntry,FALSE,FALSE,0);

	hbox=gtk_hbox_new(FALSE,0);
	caption=gtk_label_new("Command to execute");
	gtk_label_set_markup(GTK_LABEL(caption),"<small>Command to execute</small>");
	gtk_box_pack_start(GTK_BOX(hbox),caption,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),gtk_alignment_new(1.0,0.0,0.0,0.0),TRUE,TRUE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);	executableEntry=gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(vbox),executableEntry,FALSE,FALSE,0);
	
	hbox=gtk_hbox_new(FALSE,0);
	caption=gtk_label_new("DBUS Service name");
	gtk_label_set_markup(GTK_LABEL(caption),"<small>DBUS Service name</small>");
	gtk_box_pack_start(GTK_BOX(hbox),caption,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),gtk_alignment_new(1.0,0.0,0.0,0.0),TRUE,TRUE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);	serviceEntry=gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(vbox),serviceEntry,FALSE,FALSE,0);
	
	caption=gtk_label_new(NULL);
	gtk_label_set_markup(GTK_LABEL(caption),"<small><b>NOTE:</b> 'DBUS Service name' entry overrides 'Command to execute' and is entirely optional</small>");
	gtk_label_set_line_wrap(GTK_LABEL(caption),TRUE);
	gtk_label_set_justify(GTK_LABEL(caption),GTK_JUSTIFY_CENTER);
	gtk_box_pack_start(GTK_BOX(vbox),caption,FALSE,FALSE,0);

	setup->context="hildon";
	
	hbox=gtk_hbox_new(FALSE,0);
	vbox2=gtk_vbox_new(FALSE,0);
	
	termCheckBox=gtk_check_button_new_with_label("Run in terminal");
	gtk_box_pack_start(GTK_BOX(vbox2),termCheckBox,FALSE,FALSE,0);

	rootCheckBox=gtk_check_button_new_with_label("Run as root");
	gtk_box_pack_start(GTK_BOX(vbox2),rootCheckBox,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),vbox2,FALSE,FALSE,0);
	
	align=gtk_alignment_new(1.0,0.0,0.0,0.0);
	gtk_box_pack_start(GTK_BOX(hbox),align,TRUE,TRUE,0);

	iconButton=gtk_button_new_with_label("Select icon");
	setup->iconPreview=gtk_image_new_from_icon_name("qgn_list_gene_default_app",GTK_ICON_SIZE_DIALOG);
	gtk_box_pack_start(GTK_BOX(hbox),setup->iconPreview,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),iconButton,FALSE,FALSE,0);
	g_signal_connect(G_OBJECT(iconButton),"clicked",G_CALLBACK(select_icon),setup);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);

	if (edit)
	{
		gchar *appName,*iconName,*executable,*service;
		gchar *runAsRoot,*runInTerm;
		gtk_tree_model_get(gtk_tree_view_get_model(setup->view),&iter,1,&appName,2,&executable,3,&iconName,4,&runAsRoot,5,&runInTerm,6,&service,-1);
		setup->entryIter=iter;
		gtk_entry_set_text(GTK_ENTRY(appNameEntry),appName);
		gtk_image_set_from_icon_name(GTK_IMAGE(setup->iconPreview),iconName,GTK_ICON_SIZE_DIALOG);
		gtk_entry_set_text(GTK_ENTRY(executableEntry),executable);
		gtk_entry_set_text(GTK_ENTRY(serviceEntry),service);
		if (g_strcasecmp(runAsRoot,"true")==0)
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(rootCheckBox),TRUE);
		if (g_strcasecmp(runInTerm,"true")==0)
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(termCheckBox),TRUE);
	}

	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll),GTK_POLICY_NEVER,GTK_POLICY_AUTOMATIC);
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scroll),vbox);
	gtk_container_add(GTK_CONTAINER(dialog->vbox),scroll);
	gtk_widget_set_size_request(GTK_WIDGET(scroll), -1, 275);

	gtk_widget_show_all(GTK_WIDGET(dialog));
	res = gtk_dialog_run(dialog);
	if (res == GTK_RESPONSE_ACCEPT) 
	{
		const gchar *appName, *iconName, *executable,*service;
		gchar *runAsRoot="false", *runInTerm="false";
		GtkIconTheme *icon_theme;
		GdkPixbuf *icon=NULL;
		GdkPixbuf *smallIcon=NULL;
		appName=gtk_entry_get_text(GTK_ENTRY(appNameEntry));
		gtk_image_get_icon_name(GTK_IMAGE(setup->iconPreview),&iconName,NULL);
		executable=gtk_entry_get_text(GTK_ENTRY(executableEntry));
		service=gtk_entry_get_text(GTK_ENTRY(serviceEntry));
		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(termCheckBox)))
			runInTerm="true";
		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(rootCheckBox)))
			runAsRoot="true";

		if ((g_strcasecmp(appName,"")!=0)||(g_strcasecmp(executable,"")!=0))
		{
			icon_theme=gtk_icon_theme_get_default();
			icon=gtk_icon_theme_load_icon(icon_theme,iconName,64,0,NULL);
			if (icon==NULL)
			{
				icon=gtk_icon_theme_load_icon(icon_theme,"qgn_list_gene_default_app",64,0,NULL);
			}
			icon=gdk_pixbuf_scale_simple(icon,64,64,GDK_INTERP_NEAREST);
			smallIcon=gtk_icon_theme_load_icon(icon_theme,iconName,26,0,NULL);
			if (smallIcon==NULL)
			{
			  smallIcon=gtk_icon_theme_load_icon(icon_theme,"qgn_list_gene_default_app",26,0,NULL);
			}
			smallIcon=gdk_pixbuf_scale_simple(smallIcon,26,26,GDK_INTERP_NEAREST);
			if (!edit)
			{
					if (sibling!=NULL)
						gtk_list_store_insert_after(setup->entryList,&setup->entryIter,sibling);
					else
						gtk_list_store_append(setup->entryList,&setup->entryIter);
			}
			gtk_list_store_set(setup->entryList,&setup->entryIter,0,icon,1,appName,2,executable,3,iconName,4,runAsRoot,5,runInTerm,6,service,7,smallIcon,-1);
			g_object_unref(G_OBJECT(icon));
			g_object_unref(G_OBJECT(smallIcon));
		}
	}

	gtk_widget_destroy(GTK_WIDGET(dialog));
	gtk_widget_grab_focus(GTK_WIDGET(setup->view));
}

void edit_cmd(GtkButton *button, PersonalLauncherSetup *setup)
{
	GtkTreeSelection *select=gtk_tree_view_get_selection(setup->view);
	GtkTreeModel *model=gtk_tree_view_get_model(setup->view);
	GtkTreeIter iter;
	if (gtk_tree_selection_get_selected(select,&model,&iter))
	{
		dialog_add_edit(iter,NULL,TRUE,setup);
	}
}

void perform_deletion(PersonalLauncherSetup *setup)
{
	GtkTreeSelection *select=gtk_tree_view_get_selection(setup->view);
	GtkTreeModel *model=gtk_tree_view_get_model(setup->view);
	GtkTreeIter iter;
	gtk_tree_selection_get_selected(select,&model,&iter);
	gtk_list_store_remove(setup->entryList,&iter);	
}

void delete_cmd(GtkButton *button, PersonalLauncherSetup *setup)
{
	GtkTreeSelection *select=gtk_tree_view_get_selection(setup->view);
	GtkTreeModel *model=gtk_tree_view_get_model(setup->view);
	GtkTreeIter iter;
	if (gtk_tree_selection_get_selected(select,&model,&iter))
	{
		if (setup->config->confirmCheck)
		{
			GtkWidget *confirm=hildon_note_new_confirmation(setup->setupwin,"Do you really want to delete this entry?");
			gint result;
			
			result=gtk_dialog_run(GTK_DIALOG(confirm));
			gtk_widget_destroy(confirm);
			if (result==GTK_RESPONSE_OK)
			{
				perform_deletion(setup);
			}
		}
		else
		{
			perform_deletion(setup);
		}
	}
}

void move_up(GtkButton *button, PersonalLauncherSetup *setup)
{
	GtkTreeSelection *select=gtk_tree_view_get_selection(setup->view);
	GtkTreeModel *model=gtk_tree_view_get_model(setup->view);
	GtkTreeIter iterFirst,iterSecond;
	GtkTreePath *path;
	if (gtk_tree_selection_get_selected(select,&model,&iterFirst))
	{
		path=gtk_tree_model_get_path(model,&iterFirst);
		gtk_tree_path_prev(path);
		gtk_tree_model_get_iter(model,&iterSecond,path);
		gtk_list_store_swap(setup->entryList,&iterFirst,&iterSecond);
		gtk_tree_view_scroll_to_cell(setup->view,path,NULL,FALSE,0,0);
	}
}

void move_down(GtkButton *button, PersonalLauncherSetup *setup)
{
	GtkTreeSelection *select=gtk_tree_view_get_selection(setup->view);
	GtkTreeModel *model=gtk_tree_view_get_model(setup->view);
	GtkTreeIter iterFirst,iterSecond;
	GtkTreePath *path;
	if (gtk_tree_selection_get_selected(select,&model,&iterFirst))
	{
		iterSecond=iterFirst;
		if (gtk_tree_model_iter_next(model,&iterSecond))
		{
			gtk_list_store_swap(setup->entryList,&iterFirst,&iterSecond);
			path=gtk_tree_model_get_path(model,&iterFirst);
			gtk_tree_view_scroll_to_cell(setup->view,path,NULL,FALSE,0,0);
		}
	}
}

void read_key_file(PersonalLauncherSetup *setup)
{
	gchar* filename;
	gboolean fileExists;
	GKeyFile* keyFile;

	keyFile=g_key_file_new();
	filename=g_strdup(HOME_DIR);
	filename=g_strconcat(filename,"/.personal_launcher.rc",NULL);
	fileExists=g_key_file_load_from_file(keyFile,filename,G_KEY_FILE_KEEP_COMMENTS,NULL);

	GError *error=NULL;
	setup->config->iconSize=g_key_file_get_integer(keyFile,"config","icon size",&error);
	if (error)
	{
		setup->config->iconSize=40;
		g_error_free(error);
		error=NULL;
	}
	setup->config->padding=g_key_file_get_integer(keyFile,"config","padding",&error);
	if (error)
	{
		setup->config->padding=2;
		g_error_free(error);
		error=NULL;
	}
	setup->config->trans=g_key_file_get_integer(keyFile,"config","transparency",&error);
	if (error)
	{
		setup->config->trans=255;
		g_error_free(error);
		error=NULL;
	}
	setup->config->alphaComp=g_key_file_get_double(keyFile,"config","background transparency",&error);
	if (error)
	{
		setup->config->alphaComp=0;
		g_error_free(error);
		error=NULL;
	}
	setup->config->redComp=g_key_file_get_double(keyFile,"config","background red",&error);
	if (error)
	{
		setup->config->redComp=0;
		g_error_free(error);
		error=NULL;
	}
	setup->config->blueComp=g_key_file_get_double(keyFile,"config","background blue",&error);
	if (error)
	{
		setup->config->blueComp=0;
		g_error_free(error);
		error=NULL;
	}
	setup->config->greenComp=g_key_file_get_double(keyFile,"config","background green",&error);
	if (error)
	{
		setup->config->greenComp=0;
		g_error_free(error);
		error=NULL;
	}
	setup->config->radius=g_key_file_get_integer(keyFile,"config","background radius",&error);
	if (error)
	{
		setup->config->radius=10;
		g_error_free(error);
		error=NULL;
	}
	setup->config->animation=g_key_file_get_boolean(keyFile,"config","animation",&error);
	if (error)
	{
		setup->config->animation=FALSE;
		g_error_free(error);
		error=NULL;
	}
	setup->config->layoutCheck=g_key_file_get_boolean(keyFile,"config","auto layout",&error);
	if (error)
	{
		setup->config->layoutCheck=TRUE;
		g_error_free(error);
		error=NULL;
	}
	setup->config->layoutStyle=g_key_file_get_integer(keyFile,"config","layout style",&error);
	if (error)
	{
		setup->config->layoutStyle=1;
		g_error_free(error);
		error=NULL;
	}
	setup->config->numCols=g_key_file_get_integer(keyFile,"config","num cols",&error);
	if (error)
	{
		setup->config->numCols=4;
		g_error_free(error);
		error=NULL;
	}
	/*setup->config->numRows=g_key_file_get_integer(keyFile,"config","num rows",&error);
	if (error)
	{
		setup->config->numRows=6;
		g_error_free(error);
		error=NULL;
	}*/
	setup->config->confirmCheck=g_key_file_get_boolean(keyFile,"config","confirm delete",&error);
	if (error)
	{
		setup->config->confirmCheck=TRUE;
		g_error_free(error);
		error=NULL;
	}
	setup->config->zoomToggle=g_key_file_get_boolean(keyFile,"config","zoomed",&error);
	if (error)
	{
		setup->config->zoomToggle=FALSE;
		g_error_free(error);
		error=NULL;
	}
	setup->config->infoToggle=g_key_file_get_boolean(keyFile,"config","show info",&error);
	if (error)
	{
		setup->config->infoToggle=TRUE;
		g_error_free(error);
		error=NULL;
	}
	g_key_file_free(keyFile);
}

void write_key_file(PersonalLauncherSetup *setup)
{
	gchar* filename;
	GKeyFile* keyFile;
	gchar* fileData;
	FILE* rcFile;
	gsize size;
	GtkTreeIter iter;
	GtkTreeModel *model=gtk_tree_view_get_model(setup->view);
	gboolean exists;
	gint i=0;

	keyFile=g_key_file_new();
	exists=gtk_tree_model_get_iter_first(model,&iter);
	while (exists)
	{
		gchar *appName=NULL,*iconName=NULL,*executable=NULL,*service=NULL;
		gchar *runAsRoot=NULL,*runInTerm=NULL;
		gchar entry[5];
		snprintf(entry,5,"%d",i++);
		gtk_tree_model_get(model,&iter,1,&appName,2,&executable,3,&iconName,4,&runAsRoot,5,&runInTerm,6,&service,-1);
		
		if (appName==NULL) appName="";
		if (executable==NULL) executable="";
		if (iconName==NULL) iconName="";
		if (runAsRoot==NULL) runAsRoot="";
		if (runInTerm==NULL) runInTerm="";
		if (service==NULL) service="";
		
		/*gtk_tree_model_get(model,&iter,1,&appName,2,&executable,3,&iconName,-1);*/
		g_key_file_set_string(keyFile,entry,"app name",appName);
		g_key_file_set_string(keyFile,entry,"icon name",iconName);
		if (executable!=NULL)
			g_key_file_set_string(keyFile,entry,"executable",executable);
		g_key_file_set_string(keyFile,entry,"run as root",runAsRoot);
		g_key_file_set_string(keyFile,entry,"run in term",runInTerm);
		if (service!=NULL)
			g_key_file_set_string(keyFile,entry,"service",service);
		exists=gtk_tree_model_iter_next(model,&iter);
	}
	g_key_file_set_integer(keyFile,"config","icon size",setup->config->iconSize);
	g_key_file_set_integer(keyFile,"config","padding",setup->config->padding);
	g_key_file_set_integer(keyFile,"config","transparency",setup->config->trans);
	g_key_file_set_double(keyFile,"config","background transparency",setup->config->alphaComp);
	g_key_file_set_double(keyFile,"config","background red",setup->config->redComp);
	g_key_file_set_double(keyFile,"config","background blue",setup->config->blueComp);
	g_key_file_set_double(keyFile,"config","background green",setup->config->greenComp);
	g_key_file_set_integer(keyFile,"config","background radius",setup->config->radius);
	g_key_file_set_boolean(keyFile,"config","animation",setup->config->animation);
	g_key_file_set_boolean(keyFile,"config","auto layout",setup->config->layoutCheck);
	g_key_file_set_integer(keyFile,"config","layout style",setup->config->layoutStyle);
	g_key_file_set_integer(keyFile,"config","num cols",setup->config->numCols);
	g_key_file_set_boolean(keyFile,"config","confirm delete",setup->config->confirmCheck);
	g_key_file_set_boolean(keyFile,"config","zoomed",setup->config->zoomToggle);
	g_key_file_set_boolean(keyFile,"config","show info",setup->config->infoToggle);

	filename=g_strdup(HOME_DIR);
	filename=g_strconcat(filename,"/.personal_launcher.rc",NULL);
	fileData=g_key_file_to_data(keyFile,&size,NULL);
	rcFile=fopen(filename,"w");
	fputs(fileData,rcFile);
	fclose(rcFile);
	g_key_file_free(keyFile);
	g_free(fileData);
}

static void layout_style_change(GtkComboBox *comboBox, PersonalLauncherSetup *setup)
{
	if (gtk_combo_box_get_active(comboBox)==2)
	{
		gtk_widget_show(gtk_widget_get_parent(setup->numCols));
	}
	else
	{
		gtk_widget_hide(gtk_widget_get_parent(setup->numCols));
	}
}


static void layout_check_toggle(GtkToggleButton *toggleButton, PersonalLauncherSetup *setup)
{
	if (gtk_toggle_button_get_active(toggleButton))
	{
		gtk_widget_hide(gtk_widget_get_parent(setup->layoutStyle));
		gtk_widget_hide(gtk_widget_get_parent(setup->numCols));
	}
	else
	{
		gtk_widget_show(gtk_widget_get_parent(setup->layoutStyle));
		layout_style_change(GTK_COMBO_BOX(setup->layoutStyle),setup);
	}
}

static void dnd_set_data(GtkWidget *view, GdkDragContext *context, int x, int y, GtkSelectionData *selection_data, guint info, guint time, PersonalLauncherSetup *setup)
{
	GtkTreeModel *model;
	GtkTreeIter iter,sibling;
	GtkTreeSelection *selection;
	GtkTreePath *path;
	gchar *name=NULL;
	gchar *exec=NULL;
	gchar *service=NULL;
	gchar *iconName=NULL;
	GdkPixbuf *icon=NULL;
	GdkPixbuf *smallIcon=NULL;
	GtkTreeViewDropPosition drop;

	if (info==1)
	{
		selection=gtk_tree_view_get_selection(setup->appView);
		model=gtk_tree_view_get_model(setup->appView);
		gtk_tree_selection_get_selected(selection,&model,&iter);

		gtk_tree_model_get(model,&iter,0,&icon,1,&name,2,&exec,3,&iconName,6,&service,7,&smallIcon,-1);

		if (gtk_tree_view_get_dest_row_at_pos(setup->view,x,y,&path,&drop))
		{
			if (drop==GTK_TREE_VIEW_DROP_AFTER||drop==GTK_TREE_VIEW_DROP_INTO_OR_AFTER)
			{
				gtk_tree_model_get_iter(gtk_tree_view_get_model(setup->view),&sibling,path);
				gtk_list_store_insert_after(setup->entryList,&iter,&sibling);
			}
			if (drop==GTK_TREE_VIEW_DROP_BEFORE||drop==GTK_TREE_VIEW_DROP_INTO_OR_BEFORE)
			{
				gtk_tree_model_get_iter(gtk_tree_view_get_model(setup->view),&sibling,path);
				gtk_list_store_insert_before(setup->entryList,&iter,&sibling);
			}
		}
		else
		{
			gtk_list_store_append(GTK_LIST_STORE(setup->entryList),&iter);
		}

		gtk_list_store_set(GTK_LIST_STORE(setup->entryList),&iter,0,icon,1,name,2,exec,3,iconName,4,"false",5,"false",6,service,7,smallIcon,-1);
		gtk_drag_finish(context,TRUE,FALSE,time);
	}
}

static void add_command(GtkButton *button, PersonalLauncherSetup *setup)
{
		GtkTreeSelection *select=gtk_tree_view_get_selection(setup->view);
		GtkTreeModel *model=gtk_tree_view_get_model(setup->view);
		GtkTreeIter iter,sibling;
		if (gtk_tree_selection_get_selected(select,&model,&sibling))
			dialog_add_edit(iter,&sibling,FALSE,setup);
		else
			dialog_add_edit(iter,NULL,FALSE,setup);

}

static void toggle_size(GtkToggleToolButton *button, PersonalLauncherSetup *setup)
{
	if (gtk_toggle_tool_button_get_active(button))
	{
		hildon_helper_set_thumb_scrollbar(GTK_SCROLLED_WINDOW(setup->menuScroll),FALSE);
		hildon_helper_set_thumb_scrollbar(GTK_SCROLLED_WINDOW(setup->appScroll),FALSE);
		GtkTreeViewColumn *col=gtk_tree_view_get_column(setup->view,0);
		gtk_tree_view_remove_column(setup->view,col);
		col=gtk_tree_view_get_column(setup->view,0);
		gtk_tree_view_remove_column(setup->view,col);
		col=gtk_tree_view_get_column(setup->appView,0);
		gtk_tree_view_remove_column(setup->appView,col);
		col=gtk_tree_view_get_column(setup->appView,0);
		gtk_tree_view_remove_column(setup->appView,col);
		
		GtkCellRenderer *render=gtk_cell_renderer_pixbuf_new();
		gtk_tree_view_append_column(setup->view,gtk_tree_view_column_new_with_attributes(NULL,render,"pixbuf",7,NULL));
		render=gtk_cell_renderer_text_new();
		g_object_set(G_OBJECT(render),"ellipsize",PANGO_ELLIPSIZE_END,NULL);
		gtk_cell_renderer_set_fixed_size(GTK_CELL_RENDERER(render),-1,26);
		gtk_tree_view_append_column(setup->view,gtk_tree_view_column_new_with_attributes(NULL,render,"text",1,NULL));
		render=gtk_cell_renderer_pixbuf_new();
		gtk_tree_view_append_column(setup->appView,gtk_tree_view_column_new_with_attributes(NULL,render,"pixbuf",7,NULL));
		render=gtk_cell_renderer_text_new();
		g_object_set(G_OBJECT(render),"ellipsize",PANGO_ELLIPSIZE_END,NULL);
		gtk_cell_renderer_set_fixed_size(GTK_CELL_RENDERER(render),-1,26);
		gtk_tree_view_append_column(setup->appView,gtk_tree_view_column_new_with_attributes(NULL,render,"text",1,NULL));

	}
	else
	{
		hildon_helper_set_thumb_scrollbar(GTK_SCROLLED_WINDOW(setup->menuScroll),TRUE);
		hildon_helper_set_thumb_scrollbar(GTK_SCROLLED_WINDOW(setup->appScroll),TRUE);
		GtkTreeViewColumn *col=gtk_tree_view_get_column(setup->view,0);
		gtk_tree_view_remove_column(setup->view,col);
		col=gtk_tree_view_get_column(setup->view,0);
		gtk_tree_view_remove_column(setup->view,col);
		col=gtk_tree_view_get_column(setup->appView,0);
		gtk_tree_view_remove_column(setup->appView,col);
		col=gtk_tree_view_get_column(setup->appView,0);
		gtk_tree_view_remove_column(setup->appView,col);
		
		GtkCellRenderer *render=gtk_cell_renderer_pixbuf_new();
		gtk_tree_view_append_column(setup->view,gtk_tree_view_column_new_with_attributes(NULL,render,"pixbuf",0,NULL));
		render=gtk_cell_renderer_text_new();
		g_object_set(G_OBJECT(render),"ellipsize",PANGO_ELLIPSIZE_END,NULL);
		gtk_cell_renderer_set_fixed_size(GTK_CELL_RENDERER(render),-1,64);
		gtk_tree_view_append_column(setup->view,gtk_tree_view_column_new_with_attributes(NULL,render,"text",1,NULL));
		render=gtk_cell_renderer_pixbuf_new();
		gtk_tree_view_append_column(setup->appView,gtk_tree_view_column_new_with_attributes(NULL,render,"pixbuf",0,NULL));
		render=gtk_cell_renderer_text_new();
		g_object_set(G_OBJECT(render),"ellipsize",PANGO_ELLIPSIZE_END,NULL);
		gtk_cell_renderer_set_fixed_size(GTK_CELL_RENDERER(render),-1,64);
		gtk_tree_view_append_column(setup->appView,gtk_tree_view_column_new_with_attributes(NULL,render,"text",1,NULL));

	}
	setup->config->zoomToggle=gtk_toggle_tool_button_get_active(button);
	write_key_file(setup);
}

static void toggle_info(GtkToggleToolButton *button, PersonalLauncherSetup *setup)
{
	if (gtk_toggle_tool_button_get_active(button))
	{
		gtk_widget_show(setup->infoPanel);
	}
	else
	{
		gtk_widget_hide(setup->infoPanel);		
	}
	setup->config->infoToggle=gtk_toggle_tool_button_get_active(button);
	write_key_file(setup);
}

static void create_settings_dialog(GtkButton *button, PersonalLauncherSetup *setup)
{
	GtkWidget *dialog;
	GtkWidget *scroll;
	GtkWidget *vbox2, *hbox2, *caption;
	GtkWidget *vbox, *hbox, *align;
	int res;
	GtkWidget *visualFrame, *layoutFrame;
	GtkWidget *frameBox;
	GdkColor colour;
	
	dialog = gtk_dialog_new_with_buttons("Personal Launcher Settings",NULL,GTK_DIALOG_MODAL,GTK_STOCK_OK,GTK_RESPONSE_ACCEPT,NULL);

	vbox2=gtk_vbox_new(FALSE,0);
	scroll=gtk_scrolled_window_new(NULL,NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll),GTK_POLICY_NEVER,GTK_POLICY_AUTOMATIC);
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scroll),vbox2);

	visualFrame=gtk_frame_new("Visual settings");
	gtk_frame_set_label_align(GTK_FRAME(visualFrame),0.5,0.5);
	frameBox=gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(visualFrame),frameBox);
	gtk_container_add(GTK_CONTAINER(vbox2),visualFrame);
	
	vbox=gtk_vbox_new(FALSE,0);
	hbox=gtk_hbox_new(TRUE,5);
	setup->iconSizeCombo=gtk_combo_box_new_text();
	gtk_combo_box_append_text(GTK_COMBO_BOX(setup->iconSizeCombo),"0");
	gtk_combo_box_append_text(GTK_COMBO_BOX(setup->iconSizeCombo),"26");
	gtk_combo_box_append_text(GTK_COMBO_BOX(setup->iconSizeCombo),"40");
	gtk_combo_box_append_text(GTK_COMBO_BOX(setup->iconSizeCombo),"48");
	gtk_combo_box_append_text(GTK_COMBO_BOX(setup->iconSizeCombo),"56");
	gtk_combo_box_append_text(GTK_COMBO_BOX(setup->iconSizeCombo),"64");
	if (setup->config->iconSize==0)
		gtk_combo_box_set_active(GTK_COMBO_BOX(setup->iconSizeCombo),0);
	else if (setup->config->iconSize==26)
		gtk_combo_box_set_active(GTK_COMBO_BOX(setup->iconSizeCombo),1);
	else if (setup->config->iconSize==40)
		gtk_combo_box_set_active(GTK_COMBO_BOX(setup->iconSizeCombo),2);
	else if (setup->config->iconSize==48)
		gtk_combo_box_set_active(GTK_COMBO_BOX(setup->iconSizeCombo),3);
	else if (setup->config->iconSize==56)
		gtk_combo_box_set_active(GTK_COMBO_BOX(setup->iconSizeCombo),4);
	else
		gtk_combo_box_set_active(GTK_COMBO_BOX(setup->iconSizeCombo),5);
	caption=gtk_label_new("Icon size:");
	gtk_label_set_markup(GTK_LABEL(caption),"<small>Icon size:</small>");
	align=gtk_alignment_new(0,0,0,0);
	gtk_container_add(GTK_CONTAINER(align),caption);
	gtk_box_pack_start(GTK_BOX(vbox),align,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),setup->iconSizeCombo,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),vbox,TRUE,TRUE,0);

	vbox=gtk_vbox_new(FALSE,0);
	setup->trans=hildon_controlbar_new();
	hildon_controlbar_set_range(HILDON_CONTROLBAR(setup->trans),127,255);
	
	caption=gtk_label_new("Icon opacity:");
	gtk_label_set_markup(GTK_LABEL(caption),"<small>Icon opacity</small>");
	align=gtk_alignment_new(0,0,0,0);
	gtk_container_add(GTK_CONTAINER(align),caption);
	gtk_box_pack_start(GTK_BOX(vbox),align,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),setup->trans,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),vbox,TRUE,TRUE,0);
	gtk_box_pack_start(GTK_BOX(frameBox),hbox,FALSE,FALSE,0);
	hildon_controlbar_set_value(HILDON_CONTROLBAR(setup->trans),setup->config->trans);
	
	vbox=gtk_vbox_new(FALSE,0);
	hbox=gtk_hbox_new(TRUE,5);
	setup->bgColour=gtk_color_button_new();
	caption=gtk_label_new("Background colour:");
	gtk_label_set_markup(GTK_LABEL(caption),"<small>Background colour:</small>");
	align=gtk_alignment_new(0,0,0,0);
	colour.red=setup->config->redComp*(MAXSHORT*2+1);
	colour.blue=setup->config->blueComp*(MAXSHORT*2+1);
	colour.green=setup->config->greenComp*(MAXSHORT*2+1);
	gtk_color_button_set_color(GTK_COLOR_BUTTON(setup->bgColour),&colour);
	
	gtk_container_add(GTK_CONTAINER(align),caption);
	gtk_box_pack_start(GTK_BOX(vbox),align,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),setup->bgColour,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),vbox,TRUE,TRUE,0);


	vbox=gtk_vbox_new(FALSE,0);
	setup->bgTrans=hildon_controlbar_new();
	hildon_controlbar_set_range(HILDON_CONTROLBAR(setup->bgTrans),0,100);
	caption=gtk_label_new("Background opacity:");
	gtk_label_set_markup(GTK_LABEL(caption),"<small>Background opacity</small>");
	align=gtk_alignment_new(0,0,0,0);
	gtk_container_add(GTK_CONTAINER(align),caption);
	
	gtk_box_pack_start(GTK_BOX(vbox),align,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),setup->bgTrans,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),vbox,TRUE,TRUE,0);
	hildon_controlbar_set_value(HILDON_CONTROLBAR(setup->bgTrans),setup->config->alphaComp*100);

	gtk_box_pack_start(GTK_BOX(frameBox),hbox,FALSE,FALSE,0);
	
	setup->radius=hildon_number_editor_new(0,26);
	caption=hildon_caption_new(NULL,"Corner radius",setup->radius,NULL,HILDON_CAPTION_MANDATORY);
	gtk_box_pack_start(GTK_BOX(frameBox),caption,FALSE,FALSE,0);
	hildon_number_editor_set_value(HILDON_NUMBER_EDITOR(setup->radius),setup->config->radius);
	
	setup->animation=gtk_check_button_new_with_label("Enable animations");
	gtk_box_pack_start(GTK_BOX(frameBox),setup->animation,FALSE,FALSE,0);	
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(setup->animation),setup->config->animation);
	gtk_box_pack_start(GTK_BOX(vbox2),visualFrame,FALSE,FALSE,0);

	layoutFrame=gtk_frame_new("Layout entry settings");
	gtk_frame_set_label_align(GTK_FRAME(layoutFrame),0.5,0.5);
	frameBox=gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(layoutFrame),frameBox);
	gtk_container_add(GTK_CONTAINER(vbox2),layoutFrame);

	setup->padding=hildon_number_editor_new(0,64);
	caption=hildon_caption_new(NULL,"Padding between icons",setup->padding,NULL,HILDON_CAPTION_MANDATORY);
	gtk_box_pack_start(GTK_BOX(frameBox),caption,FALSE,FALSE,0);
	hildon_number_editor_set_value(HILDON_NUMBER_EDITOR(setup->padding),setup->config->padding);

	setup->layoutCheck=gtk_check_button_new_with_label("Use resizable layout");
	gtk_box_pack_start(GTK_BOX(frameBox),setup->layoutCheck,FALSE,FALSE,0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(setup->layoutCheck),setup->config->layoutCheck);
	g_signal_connect(G_OBJECT(setup->layoutCheck),"toggled",G_CALLBACK(layout_check_toggle),setup);
	
	vbox=gtk_vbox_new(FALSE,0);
	setup->layoutStyle=gtk_combo_box_new_text();
	gtk_combo_box_append_text(GTK_COMBO_BOX(setup->layoutStyle),"Columns");
	gtk_combo_box_append_text(GTK_COMBO_BOX(setup->layoutStyle),"Rows");
	gtk_combo_box_append_text(GTK_COMBO_BOX(setup->layoutStyle),"Grid");
	caption=gtk_label_new("Automatic layout orientation:");
	gtk_label_set_markup(GTK_LABEL(caption),"<small>Automatic layout orientation:</small>");
	align=gtk_alignment_new(0,0,0,0);
	gtk_container_add(GTK_CONTAINER(align),caption);
	gtk_combo_box_set_active(GTK_COMBO_BOX(setup->layoutStyle),setup->config->layoutStyle);
	g_signal_connect(G_OBJECT(setup->layoutStyle),"changed",G_CALLBACK(layout_style_change),setup);
	gtk_box_pack_start(GTK_BOX(vbox),align,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),setup->layoutStyle,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(frameBox),vbox,FALSE,FALSE,0);
	
	setup->numCols=hildon_number_editor_new(1,30);
	caption=hildon_caption_new(NULL,"Number of columns",setup->numCols,FALSE,HILDON_CAPTION_MANDATORY);
	hildon_number_editor_set_value(HILDON_NUMBER_EDITOR(setup->numCols),setup->config->numCols);
	gtk_box_pack_start(GTK_BOX(frameBox),caption,FALSE,FALSE,0);
	
	setup->confirmCheck=gtk_check_button_new_with_label("Ask for confirmation when deleting");
	align=gtk_alignment_new(0.5,0,0,0);
	gtk_container_add(GTK_CONTAINER(align),setup->confirmCheck);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(setup->confirmCheck),setup->config->confirmCheck);
	gtk_box_pack_start(GTK_BOX(vbox2),align,FALSE,FALSE,0);

	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(dialog)->vbox),scroll);

	gtk_widget_set_size_request(GTK_WIDGET(dialog), -1, 400);
	gtk_widget_show_all(GTK_WIDGET(dialog));
	layout_check_toggle(GTK_TOGGLE_BUTTON(setup->layoutCheck),setup);
	gtk_container_check_resize(GTK_CONTAINER(layoutFrame));
	gtk_container_check_resize(GTK_CONTAINER(vbox2));
	res = gtk_dialog_run(GTK_DIALOG(dialog));
	if (res==GTK_RESPONSE_ACCEPT)
	{
		gint size=gtk_combo_box_get_active(GTK_COMBO_BOX(setup->iconSizeCombo));
		switch (size)
		{
			case 0:
				setup->config->iconSize=0;
				break;
			case 1:
				setup->config->iconSize=26;
				break;
			case 2:
				setup->config->iconSize=40;
				break;
			case 3:
				setup->config->iconSize=48;
				break;
			case 4:
				setup->config->iconSize=56;
				break;
			default:
				setup->config->iconSize=64;
				break;
		}
		setup->config->layoutCheck=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(setup->layoutCheck));
		setup->config->layoutStyle=gtk_combo_box_get_active(GTK_COMBO_BOX(setup->layoutStyle));
		setup->config->numCols=hildon_number_editor_get_value(HILDON_NUMBER_EDITOR(setup->numCols));
		setup->config->confirmCheck=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(setup->confirmCheck));
		setup->config->padding=hildon_number_editor_get_value(HILDON_NUMBER_EDITOR(setup->padding));
		setup->config->trans=hildon_controlbar_get_value(HILDON_CONTROLBAR(setup->trans));
		setup->config->alphaComp=(gdouble)(hildon_controlbar_get_value(HILDON_CONTROLBAR(setup->bgTrans)))/100;
		gtk_color_button_get_color(GTK_COLOR_BUTTON(setup->bgColour),&colour);
		setup->config->redComp=(double)colour.red/(MAXSHORT*2+1);
		setup->config->blueComp=(double)colour.blue/(MAXSHORT*2+1);
		setup->config->greenComp=(double)colour.green/(MAXSHORT*2+1);
		setup->config->radius=hildon_number_editor_get_value(HILDON_NUMBER_EDITOR(setup->radius));
		setup->config->animation=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(setup->animation));
		write_key_file(setup);
	}
	gtk_widget_destroy(GTK_WIDGET(dialog));
}

static void row_changed(GtkTreeModel *model, GtkTreePath *path, GtkTreeIter *iter, PersonalLauncherSetup *setup)
{
	write_key_file(setup);
}

static void row_deleted(GtkTreeModel *model, GtkTreePath *path, PersonalLauncherSetup *setup)
{
	write_key_file(setup);
}

void run_setup(PersonalLauncherSetup *setup)
{
	GtkWidget *hbox, *vbox;
	GtkWidget *vbox2, *hbox2, *caption;
	GtkSizeGroup *group;

	read_key_file(setup);
	
	setup->window=GTK_WINDOW(hildon_window_new());
	g_set_application_name("Personal Launcher");
	gtk_window_set_icon_name(setup->window,"personal-launcher");

	hbox=gtk_hbox_new(FALSE,0);
	vbox=gtk_vbox_new(FALSE,0);
	hbox2=gtk_hbox_new(TRUE,0);
	vbox2=gtk_vbox_new(FALSE,0);
	
	caption=gtk_label_new("Your Personal Launcher:");
	gtk_label_set_markup(GTK_LABEL(caption),"<small><b>Your Personal Launcher:</b></small>");
	gtk_box_pack_start(GTK_BOX(vbox2),caption,FALSE,FALSE,0);

	gchar *parseString=g_strconcat("style \"my-style\"\n","{\n","GtkScrolledWindow::scrollbar-spacing = 0\n","}\n","class \"GtkScrolledWindow\" style \"my-style\"\n",NULL);
	gtk_rc_parse_string(parseString);
	gtk_rc_reset_styles(gtk_settings_get_for_screen(gdk_screen_get_default()));
	g_free(parseString);

	setup->view = setup_make_view(setup);
	g_signal_connect(G_OBJECT(setup->view),"drag_data_get",G_CALLBACK(dnd_set_data),setup);
	g_signal_connect(G_OBJECT(gtk_tree_view_get_model(setup->view)),"row_changed",G_CALLBACK(row_changed),setup);
	g_signal_connect(G_OBJECT(gtk_tree_view_get_model(setup->view)),"row_deleted",G_CALLBACK(row_deleted),setup);
	g_signal_connect(G_OBJECT(gtk_tree_view_get_model(setup->view)),"row_inserted",G_CALLBACK(row_changed),setup);

	setup->menuScroll = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(setup->menuScroll), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
	gtk_scrolled_window_set_shadow_type(GTK_SCROLLED_WINDOW(setup->menuScroll),GTK_SHADOW_OUT);
	
	gtk_container_add(GTK_CONTAINER(setup->menuScroll), GTK_WIDGET(setup->view));
	hildon_helper_set_thumb_scrollbar(GTK_SCROLLED_WINDOW(setup->menuScroll),TRUE);
	
	gtk_box_pack_start(GTK_BOX(vbox2),setup->menuScroll,TRUE,TRUE,0);
	gtk_box_pack_start(GTK_BOX(hbox2),vbox2,TRUE,TRUE,0);

	vbox2=gtk_vbox_new(FALSE,0);
	caption=gtk_label_new("Available Applications:");
	gtk_label_set_markup(GTK_LABEL(caption),"<small><b>Available Applications:</b></small>");
	gtk_box_pack_start(GTK_BOX(vbox2),caption,FALSE,FALSE,0);
	
	setup->appView = setup_make_icon_view(setup);

	setup->appScroll = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(setup->appScroll), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
	gtk_container_add(GTK_CONTAINER(setup->appScroll), GTK_WIDGET(setup->appView));
	gtk_scrolled_window_set_shadow_type(GTK_SCROLLED_WINDOW(setup->appScroll),GTK_SHADOW_OUT);
	hildon_helper_set_thumb_scrollbar(GTK_SCROLLED_WINDOW(setup->appScroll),TRUE);
	
	gtk_box_pack_start(GTK_BOX(vbox2),setup->appScroll,TRUE,TRUE,0);
	gtk_box_pack_start(GTK_BOX(hbox2),vbox2,TRUE,TRUE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox2,TRUE,TRUE,0);
	
	setup->infoPanel=gtk_vbox_new(FALSE,0);
	setup->nameLabel=gtk_label_new("Name");
	gtk_misc_set_alignment(GTK_MISC(setup->nameLabel),0,0.5);
	gtk_label_set_ellipsize(GTK_LABEL(setup->nameLabel),PANGO_ELLIPSIZE_END);
	setup->execLabel=gtk_label_new("executable");
	gtk_label_set_markup(GTK_LABEL(setup->execLabel),"<small>executable</small>");
	gtk_label_set_ellipsize(GTK_LABEL(setup->execLabel),PANGO_ELLIPSIZE_END);
	gtk_misc_set_alignment(GTK_MISC(setup->execLabel),0,0.5);
	setup->dbusLabel=gtk_label_new("com.nokia.dbus");
	gtk_label_set_markup(GTK_LABEL(setup->dbusLabel),"<small>com.nokia.dbus</small>");
	gtk_label_set_ellipsize(GTK_LABEL(setup->dbusLabel),PANGO_ELLIPSIZE_END);
	gtk_misc_set_alignment(GTK_MISC(setup->dbusLabel),0,0.5);
	
	group=gtk_size_group_new(GTK_SIZE_GROUP_HORIZONTAL);
	
	setup->nameCaption=hildon_caption_new(group,"Name",setup->nameLabel,NULL,HILDON_CAPTION_MANDATORY);
	gtk_box_pack_start(GTK_BOX(setup->infoPanel),setup->nameCaption,FALSE,FALSE,0);
	setup->execCaption=hildon_caption_new(group,"Executable",setup->execLabel,NULL,HILDON_CAPTION_MANDATORY);
	hildon_caption_set_label_markup(HILDON_CAPTION(setup->execCaption),"<small>Executable</small>");
	gtk_box_pack_start(GTK_BOX(setup->infoPanel),setup->execCaption,FALSE,FALSE,0);
	hildon_caption_set_label_alignment(HILDON_CAPTION(setup->execCaption),0.5);
	setup->dbusCaption=hildon_caption_new(group,"DBUS",setup->dbusLabel,NULL,HILDON_CAPTION_MANDATORY);
	hildon_caption_set_label_markup(HILDON_CAPTION(setup->dbusCaption),"<small>DBUS</small>");
	gtk_box_pack_start(GTK_BOX(setup->infoPanel),setup->dbusCaption,FALSE,FALSE,0);
	hildon_caption_set_label_alignment(HILDON_CAPTION(setup->dbusCaption),0.5);
	
	gtk_box_pack_start(GTK_BOX(vbox),setup->infoPanel,FALSE,FALSE,0);
	
	GtkWidget *toolbar=gtk_toolbar_new();

	GtkToolItem *insertButton=gtk_tool_button_new(NULL,"Insert");
	gtk_tool_button_set_icon_name(GTK_TOOL_BUTTON(insertButton),"pl-toolbar-add");
	gtk_tool_item_set_expand(GTK_TOOL_ITEM(insertButton),TRUE);
	g_signal_connect(G_OBJECT(insertButton),"clicked",G_CALLBACK(add_command),setup);
	gtk_toolbar_insert(GTK_TOOLBAR(toolbar),insertButton,-1);

	GtkToolItem *editButton=gtk_tool_button_new(NULL,"Edit");
	gtk_tool_button_set_icon_name(GTK_TOOL_BUTTON(editButton),"pl-toolbar-edit");
	gtk_tool_item_set_expand(GTK_TOOL_ITEM(editButton),TRUE);
	g_signal_connect(G_OBJECT(editButton),"clicked",G_CALLBACK(edit_cmd),setup);
	gtk_toolbar_insert(GTK_TOOLBAR(toolbar),editButton,-1);

	GtkToolItem *deleteButton=gtk_tool_button_new(NULL,"Delete");
	gtk_tool_button_set_icon_name(GTK_TOOL_BUTTON(deleteButton),"pl-toolbar-delete");
	gtk_tool_item_set_expand(GTK_TOOL_ITEM(deleteButton),TRUE);
	g_signal_connect(G_OBJECT(deleteButton),"clicked",G_CALLBACK(delete_cmd),setup);
	gtk_toolbar_insert(GTK_TOOLBAR(toolbar),deleteButton,-1);

	GtkToolItem *separator=gtk_separator_tool_item_new();
	gtk_toolbar_insert(GTK_TOOLBAR(toolbar),separator,-1);
	
	GtkToolItem *settingsButton=gtk_tool_button_new(NULL,"Settings");
	gtk_tool_button_set_icon_name(GTK_TOOL_BUTTON(settingsButton),"pl-toolbar-settings");
	gtk_tool_item_set_expand(GTK_TOOL_ITEM(settingsButton),TRUE);
	g_signal_connect(G_OBJECT(settingsButton),"clicked",G_CALLBACK(create_settings_dialog),setup);
	gtk_toolbar_insert(GTK_TOOLBAR(toolbar),settingsButton,-1);

	GtkToolItem *zoomButton=gtk_toggle_tool_button_new();
	gtk_tool_button_set_label(GTK_TOOL_BUTTON(zoomButton),"Zoom");
	gtk_tool_button_set_icon_name(GTK_TOOL_BUTTON(zoomButton),"pl-toolbar-zoom");
	gtk_tool_item_set_expand(GTK_TOOL_ITEM(zoomButton),TRUE);
	gtk_toggle_tool_button_set_active(GTK_TOGGLE_TOOL_BUTTON(zoomButton),setup->config->zoomToggle);
	g_signal_connect(G_OBJECT(zoomButton),"toggled",G_CALLBACK(toggle_size),setup);
	gtk_toolbar_insert(GTK_TOOLBAR(toolbar),zoomButton,-1);

	GtkToolItem *infoButton=gtk_toggle_tool_button_new();
	gtk_tool_button_set_label(GTK_TOOL_BUTTON(infoButton),"Zoom");
	gtk_tool_button_set_icon_name(GTK_TOOL_BUTTON(infoButton),"pl-toolbar-info");
	gtk_tool_item_set_expand(GTK_TOOL_ITEM(infoButton),TRUE);
	gtk_toggle_tool_button_set_active(GTK_TOGGLE_TOOL_BUTTON(infoButton),setup->config->infoToggle);
	g_signal_connect(G_OBJECT(infoButton),"toggled",G_CALLBACK(toggle_info),setup);
	gtk_toolbar_insert(GTK_TOOLBAR(toolbar),infoButton,-1);

	hildon_window_add_toolbar(HILDON_WINDOW(setup->window),GTK_TOOLBAR(toolbar));
	gtk_container_add(GTK_CONTAINER(setup->window),vbox);
	gtk_widget_show_all(setup->window);

	toggle_info(GTK_TOGGLE_TOOL_BUTTON(infoButton),setup);
	toggle_size(GTK_TOGGLE_TOOL_BUTTON(zoomButton),setup);
	
	if (setup->appView)
	{
		GtkTreePath *path;
		GtkTreeIter iter;
		GtkTreeModel *model=gtk_tree_view_get_model(setup->appView);
		gtk_tree_model_get_iter_first(model,&iter);
		path=gtk_tree_model_get_path(model,&iter);
		gtk_tree_view_set_cursor(setup->appView,path,NULL,FALSE);
	}
	g_signal_connect( G_OBJECT(setup->window), "delete_event", gtk_main_quit, NULL );
}

static int pl_rpc_handler(const gchar *interface,const gchar *method,GArray *arguments,PersonalLauncherSetup *setup,osso_rpc_t *retval)
{
	if (!g_strcasecmp(method,"top_application"))
	{
		if (setup->window)
			gtk_window_present(GTK_WINDOW(setup->window));
		else
			run_setup(setup);
		
		retval->type=DBUS_TYPE_INT32;
		retval->value.i=0;
		return OSSO_OK;
	}
}

int main( int argc, char* argv[] )
{
	PersonalLauncherSetup *setup=g_new0(PersonalLauncherSetup,1);
	PersonalLauncherSetupConfig *config=g_new0(PersonalLauncherSetupConfig,1);
	
	setup->config=config;
	
	setlocale(LC_ALL,"");
	bindtextdomain("maemo-af-desktop","/usr/share/locale");
	textdomain("maemo-af-desktop");
	
	gtk_init( &argc, &argv );
	
	setup->osso=osso_initialize("personallaunchersetup","0.6",TRUE,NULL);
	osso_rpc_set_default_cb_f(setup->osso,(osso_rpc_cb_f *)pl_rpc_handler,setup);
	
	run_setup(setup);
	
	gtk_main();
	
	return 0;
}
