
#ifndef PERSONAL_LAUNCHER_SETUP_H_
#define PERSONAL_LAUNCHER_SETUP_H_

#include <libosso.h>
#include <gtk/gtk.h>

/* Common struct types declarations */
typedef struct _PersonalLauncherSetupConfig PersonalLauncherSetupConfig;
typedef struct _PersonalLauncherSetup PersonalLauncherSetup;

/* Instance struct */
struct _PersonalLauncherSetupConfig
{
	gint iconSize;
	gint padding;
	gint trans;
	gdouble alphaComp;
	gdouble redComp;
	gdouble blueComp;
	gdouble greenComp;
	gint radius;
	gboolean animation;
	gboolean layoutCheck;
	gint layoutStyle;
	gint numCols;
	gboolean confirmCheck;
	gboolean zoomToggle;
	gboolean infoToggle;
};
/* Instance struct */
struct _PersonalLauncherSetup
{
	PersonalLauncherSetupConfig *config;
	GtkTreeView *view;
	GtkTreeView *appView;
	GtkWindow *setupwin;
	GtkWindow *window;
	GtkListStore *entryList;
	GtkTreeIter entryIter;
	GtkWidget *iconSizeCombo;
	GtkWidget *colourButton;
	GtkWidget *layoutCheck;
	GtkWidget *layoutStyle;
	GtkWidget *numCols;
	GtkWidget *padding;
	GtkWidget *animation;
	GtkWidget *radius;
	GtkWidget *bgColour;
	GtkWidget *bgTrans;
	GtkWidget *trans;
	gchar *context;
	GtkWidget *iconPreview;
	GtkWidget *nameLabel, *execLabel, *dbusLabel;
	GtkWidget *nameCaption, *execCaption, *dbusCaption;
	GtkWidget *confirmCheck;
	GtkWidget *iconView;
	GtkWidget *selectDialog;
	GtkWidget *infoPanel;
	GtkWidget *menuScroll;
	GtkWidget *appScroll;
	osso_context_t *osso;
};

void select_icon(GtkButton *button, PersonalLauncherSetup *setup);
void select_icon_file(GtkButton *button, PersonalLauncherSetup *setup);
void run_setup(PersonalLauncherSetup *setup);

#endif
