/*
 * Copyright (c) 2008 Nokia Corporation
 * Contact: integration@maemo.org
 *
 * Authors: Hallyson Melo <hallyson.melo@indt.org.br>
 *          Kyller Gorgonio <kyllercg@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 */

#ifndef __NM_MAIN_DIALOG_H__
#define __NM_MAIN_DIALOG_H__

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>

G_BEGIN_DECLS

#define NM_ADVANCED_MODE                1
#define NM_BASIC_MODE                   2

#define NM_CONTROL_PANEL                1
#define NM_STATUS_MENU                  2

#define NM_RESPONSE_ADVANCED            1000
#define NM_RESPONSE_BASIC               1001
#define NM_RESPONSE_RESET               1002
#define NM_RESPONSE_APPLY               1003
#define NM_RESPONSE_CLOSE               1004

#define NM_MAIN_DIALOG_TYPE             (nm_main_dialog_get_type ())
#define NM_MAIN_DIALOG(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), NM_MAIN_DIALOG_TYPE, NmMainDialog))
#define NM_MAIN_DIALOG_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), NM_MAIN_DIALOG_TYPE, NmMainDialogClass))
#define IS_NM_MAIN_DIALOG(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NM_MAIN_DIALOG_TYPE))
#define IS_NM_MAIN_DIALOG_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), NM_MAIN_DIALOG_TYPE))
#define NM_MAIN_DIALOG_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), NM_MAIN_DIALOG_TYPE, NmMainDialogClass))

typedef struct _NmMainDialog      NmMainDialog;
typedef struct _NmMainDialogClass NmMainDialogClass;

struct _NmMainDialogClass
{
    GtkDialogClass parent_class;
};

struct _NmMainDialog
{
    GtkDialog parent;
};

GType       nm_main_dialog_get_type (void);
GtkWidget*  nm_main_dialog_new      (void);

void nm_main_dialog_run (NmMainDialog *, int );
gboolean process_bt_panel_input (NmMainDialog *, int);
gboolean process_usb_panel_input (NmMainDialog *, int);
gboolean process_wlan_panel_input (NmMainDialog *, int);

G_END_DECLS

#endif
