#ifndef PACKAGE_H
#define PACKAGE_H

/*
  MaemoRate - Rate maemo packages
  Copyright (C) 2007  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <Lum/Model/Table.h>

class Package : public Lum::Model::ListTable::Entry
{
private:
  std::wstring         name;
  std::wstring         version;
  std::wstring         description;
  int                  score;
  mutable Lum::Object* nameObject;
  mutable Lum::Object* ratingObject;

public:
  Package(Lum::Model::ListTable *table,
          const std::wstring& name,
          const std::wstring& version,
          const std::wstring& description,
          int score);
  ~Package();

  Lum::Object* GetObject(size_t column) const;
  std::wstring GetString(size_t column) const;

  std::wstring GetName() const;
  std::wstring GetVersion() const;

  bool IsGreater(const Entry* other, size_t column) const;

  void UpdateScore(int score);
};


#endif

