/*
 * Copyright: (C) 2009 Bruce W. Forsberg
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 *   Bruce Forsberg  bruce.forsberg@gmail.com
 *
 */

#ifndef OTRPLAYER_THREAD_H
#define OTRPLAYER_THREAD_H

#include <QThread>
#include <QString>



class otrplayer_thread : public QThread
{ 

public:
   otrplayer_thread();
   ~otrplayer_thread();

   void
   setName(QString name);

   QString&
   getName();

   void
   setOffset(long offset);

   int
   getKBPS();

   int
   getTotalSec();

   int
   getSeconds();

   int
   getSamplesPerSecond();


   void
   run();

private:

   QString name;
   int kbps;
   int total_sec;
   long long_offset;
   int sec;
   int samplespersecond;


};

#endif // OTRPLAYER_THREAD_H
