/*
 * Copyright: (C) 2009 Bruce W. Forsberg
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 *   Bruce Forsberg  bruce.forsberg@gmail.com
 *
 */

#include "MyQ3ListViewItem.h"
#include <qstring.h>
#include <qtextstream.h>


MyQ3ListViewItem::MyQ3ListViewItem(Q3ListView * parent) : Q3ListViewItem(parent)
{
}

MyQ3ListViewItem::MyQ3ListViewItem(MyQ3ListViewItem * parent) : Q3ListViewItem(parent)
{
}

MyQ3ListViewItem::MyQ3ListViewItem(Q3ListView * parent, MyQ3ListViewItem * after) : Q3ListViewItem(parent, after)
{
}

MyQ3ListViewItem::MyQ3ListViewItem(MyQ3ListViewItem * parent, MyQ3ListViewItem * after) : Q3ListViewItem(parent, after)
{
}

MyQ3ListViewItem::MyQ3ListViewItem::MyQ3ListViewItem(Q3ListView * parent,
                const QString& str1, const QString& str2,
		const QString& str3, const QString& str4,
                const QString& str5, const QString& str6,
		const QString& str7, const QString& str8) : Q3ListViewItem(parent, str1, str2, str3, str4, str5, str6, str7, str8)
{
}

MyQ3ListViewItem::MyQ3ListViewItem(MyQ3ListViewItem * parent,
                const QString& str1, const QString& str2,
		const QString& str3, const QString& str4,
                const QString& str5, const QString& str6,
		const QString& str7, const QString& str8) : Q3ListViewItem(parent, str1, str2, str3, str4, str5, str6, str7, str8)
{
}

MyQ3ListViewItem::MyQ3ListViewItem(Q3ListView * parent, MyQ3ListViewItem * after,
                const QString& str1, const QString& str2,
		const QString& str3, const QString& str4,
                const QString& str5, const QString& str6,
		const QString& str7, const QString& str8) : Q3ListViewItem(parent, after, str1, str2, str3, str4, str5, str6, str7, str8)
{
}

MyQ3ListViewItem::MyQ3ListViewItem(MyQ3ListViewItem * parent, MyQ3ListViewItem * after,
                const QString& str1, const QString& str2,
		const QString& str3, const QString& str4,
                const QString& str5, const QString& str6,
		const QString& str7, const QString& str8) : Q3ListViewItem(parent, after, str1, str2, str3, str4, str5, str6, str7, str8)
{
}

MyQ3ListViewItem::~MyQ3ListViewItem()
{
}

int
MyQ3ListViewItem::compare(Q3ListViewItem * i, int col, bool ascending) const
{
   // IF position or length then sort as time MM:SS
   if (col == 1 || col == 2)
   {
      int  min;
      int  sec1, sec2;
      QString str1 = text(col);
      QString str2 = i->text(col);
      QTextStream ts1(&str1);
      QTextStream ts2(&str2);
      QChar   dummy;

      ts1 >> min >> dummy >> sec1;
      sec1 = sec1 + min * 60;

      ts2 >> min >> dummy >> sec2;
      sec2 = sec2 + min * 60;

      if (sec1 > sec2)
         return 1;
      else if (sec2 > sec1)
	 return -1;
      else
	 return 0;
   }
   // IF KBPS or RATE then sort as a number
   else if (col == 3 || col == 4)
   {
      int first = atoi(text(col));
      int second = atoi(i->text(col));
      if (first > second)
         return 1;
      else if (second > first)
	 return -1;
      else
	 return 0;
   }
   else
   {
      return Q3ListViewItem::compare(i, col, ascending);
   }
}


