/*
 * Copyright: (C) 2003 Bruce W. Forsberg
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 *   Bruce Forsberg  forsberg@tns.net
 *
 */

#ifndef OTRPLAYERFILE_H
#define OTRPLAYERFILE_H


class QFile;
class QStringList;
class QString;


class otrplayerfile
{ 

public:

    enum key_enum
    {
       CALENDAR_KEY,
       ADDRESS_KEY,
       HOME_KEY,
       MENU_KEY,
       EMAIL_KEY,
       UP_KEY,
       DOWN_KEY,
       SPACE_KEY
    } ;

    otrplayerfile();
    ~otrplayerfile();

    void
    process(
       QStringList& files);

    long
    getOffset(QString& file);

    void
    storeOffset(
       QString& file,
       long offset);

    int
    getButton(key_enum key);

    void
    setButton(
       key_enum key,
       int      value);

    void
    getDirs(
       QStringList& lst,
       QStringList& tree);

    void
    setDir(
       QString dir,
       QString tree);

    void
    deleteDir(QString dir);

    void
    setAdvance(
       int  mode,
       int  sec);

    bool
    getAdvance(
       int  mode,
       int& value);

    void
    setFont(int font);

    bool
    getFont(int& font);

    void
    storePlayedFile(QString& file);

    void
    getPlayedFile(QString& file);


private:

   void
   readEntries(
      QStringList& io_files,
      QStringList& io_offset,
      QStringList& io_date);

   void
   writeEntries(
      QStringList& io_files,
      QStringList& io_offset,
      QStringList& io_date);

   void
   convertV20();


QFile   *_file;


};

#endif // OTRPLAYERFILE_H
