/*
 * Copyright: (C) 2003 Bruce W. Forsberg
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 *   Bruce Forsberg  forsberg@tns.net
 *
 */

#ifndef OTRPLAYER_H
#define OTRPLAYER_H

#include "otrplayerbase.h"

#include <qstring.h>


class QApplication;
class QStringList;
class otrplayer_audio;
class aflibAudioFile;
class aflibAudioPitch;
class otrplayerfile;


class otrplayer: public mainForm 
{ 

public:
   otrplayer(QApplication *app, bool debug);
   ~otrplayer();

   void
   play();

   void
   stop();

   void
   ff();

   void
   rev();

   void
   slider(int value);

   void
   pitchCallback(int value);

   void
   pitchEnable();

   void
   volumeChange(int value);

   void
   calendarCallback(int value);

   void
   addressCallback(int value);

   void
   homeCallback(int value);

   void
   menuCallback(int value);

   void
   emailCallback(int value);

   void
   setDir();

   void
   deleteDir();

   void
   ffCallback(int value);

   void
   rewCallback(int value);

   void
   removeFiles();

   void
   fontSize(int size);

#if 0
   void
   pcmciaMessage(const QCString &msg, const QByteArray &);
#endif


private:

   void
   initButtons();

   void
   initDirs();

   void
   displayID3(QString& file_str);

   void
   seekSeconds(int sec);

   void
   setup(QString& file);

   void
   getFiles();

   void
   secondsToQString(
      int sec,
      QString&  str);

   void
   QStringToSeconds(
      int& sec,
      QString  str);

   void
   keyPressEvent(QKeyEvent *e);

   void
   buildDirTree(
      QString  str,
      QStringList&  lst);

   void
   run();

   void
   prepareNextFile();

   bool
   performKeyEvent(int func_event);

   void
   lookForDecoders();



aflibAudioFile   *_input;
aflibAudioFile   *_output;
aflibAudioPitch  *_pitch;
otrplayer_audio  *_a;
QApplication     *_app;
Q3ListViewItem    *_item;
int               _channels;
int               _samples_per_second;
long long         _current_position;
long long         _total_size;
bool              _stop;
bool              _pitch_enabled;
QTimer           *_timer;
otrplayerfile    *_otr_file;
bool              _mount_while_play;
bool              _file_was_playing_when_unmounted;
QString           _file;
bool              _debug;


};

#endif // OTRPLAYER_H
